/* THIS FILE IS AUTOMATICALLY GENERATED, DO NOT MODIFY */

/*
 * schema-defined QAPI visitor functions
 *
 * Copyright IBM, Corp. 2011
 *
 * Authors:
 *  Anthony Liguori   <aliguori@us.ibm.com>
 *
 * This work is licensed under the terms of the GNU LGPL, version 2.1 or later.
 * See the COPYING.LIB file in the top-level directory.
 *
 */

#include "qemu-common.h"
#include "qapi-visit.h"

#ifndef QAPI_VISIT_BUILTIN_VISITOR_DEF_H
#define QAPI_VISIT_BUILTIN_VISITOR_DEF_H


void visit_type_strList(Visitor *m, strList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                strList *native_i = (strList *)i;
                visit_type_str(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_intList(Visitor *m, intList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                intList *native_i = (intList *)i;
                visit_type_int(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_numberList(Visitor *m, numberList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                numberList *native_i = (numberList *)i;
                visit_type_number(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_boolList(Visitor *m, boolList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                boolList *native_i = (boolList *)i;
                visit_type_bool(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_int8List(Visitor *m, int8List ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                int8List *native_i = (int8List *)i;
                visit_type_int8(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_int16List(Visitor *m, int16List ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                int16List *native_i = (int16List *)i;
                visit_type_int16(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_int32List(Visitor *m, int32List ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                int32List *native_i = (int32List *)i;
                visit_type_int32(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_int64List(Visitor *m, int64List ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                int64List *native_i = (int64List *)i;
                visit_type_int64(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_uint8List(Visitor *m, uint8List ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                uint8List *native_i = (uint8List *)i;
                visit_type_uint8(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_uint16List(Visitor *m, uint16List ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                uint16List *native_i = (uint16List *)i;
                visit_type_uint16(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_uint32List(Visitor *m, uint32List ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                uint32List *native_i = (uint32List *)i;
                visit_type_uint32(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_uint64List(Visitor *m, uint64List ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                uint64List *native_i = (uint64List *)i;
                visit_type_uint64(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

#endif /* QAPI_VISIT_BUILTIN_VISITOR_DEF_H */


void visit_type_ErrorClassList(Visitor *m, ErrorClassList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ErrorClassList *native_i = (ErrorClassList *)i;
                visit_type_ErrorClass(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ErrorClass(Visitor *m, ErrorClass * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, ErrorClass_lookup, "ErrorClass", name, errp);
}

static void visit_type_NameInfo_fields(Visitor *m, NameInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_name : NULL, "name", &err);
    if (obj && (*obj)->has_name) {
        visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_NameInfo(Visitor *m, NameInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "NameInfo", name, sizeof(NameInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_NameInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NameInfoList(Visitor *m, NameInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NameInfoList *native_i = (NameInfoList *)i;
                visit_type_NameInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_VersionInfo_qemu_fields(Visitor *m, VersionInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->qemu.major : NULL, "major", &err);
    visit_type_int(m, obj ? &(*obj)->qemu.minor : NULL, "minor", &err);
    visit_type_int(m, obj ? &(*obj)->qemu.micro : NULL, "micro", &err);

    error_propagate(errp, err);
}

static void visit_type_VersionInfo_fields(Visitor *m, VersionInfo ** obj, Error **errp)
{
    Error *err = NULL;
    if (!error_is_set(errp)) {
        Error **errp = &err; /* from outer scope */
        Error *err = NULL;
        visit_start_struct(m, NULL, "", "qemu", 0, &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_VersionInfo_qemu_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
    visit_type_str(m, obj ? &(*obj)->package : NULL, "package", &err);

    error_propagate(errp, err);
}

void visit_type_VersionInfo(Visitor *m, VersionInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "VersionInfo", name, sizeof(VersionInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_VersionInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_VersionInfoList(Visitor *m, VersionInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                VersionInfoList *native_i = (VersionInfoList *)i;
                visit_type_VersionInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_KvmInfo_fields(Visitor *m, KvmInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_bool(m, obj ? &(*obj)->enabled : NULL, "enabled", &err);
    visit_type_bool(m, obj ? &(*obj)->present : NULL, "present", &err);

    error_propagate(errp, err);
}

void visit_type_KvmInfo(Visitor *m, KvmInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "KvmInfo", name, sizeof(KvmInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_KvmInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_KvmInfoList(Visitor *m, KvmInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                KvmInfoList *native_i = (KvmInfoList *)i;
                visit_type_KvmInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_RunStateList(Visitor *m, RunStateList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                RunStateList *native_i = (RunStateList *)i;
                visit_type_RunState(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_RunState(Visitor *m, RunState * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, RunState_lookup, "RunState", name, errp);
}

static void visit_type_SnapshotInfo_fields(Visitor *m, SnapshotInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->id : NULL, "id", &err);
    visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);
    visit_type_int(m, obj ? &(*obj)->vm_state_size : NULL, "vm-state-size", &err);
    visit_type_int(m, obj ? &(*obj)->date_sec : NULL, "date-sec", &err);
    visit_type_int(m, obj ? &(*obj)->date_nsec : NULL, "date-nsec", &err);
    visit_type_int(m, obj ? &(*obj)->vm_clock_sec : NULL, "vm-clock-sec", &err);
    visit_type_int(m, obj ? &(*obj)->vm_clock_nsec : NULL, "vm-clock-nsec", &err);

    error_propagate(errp, err);
}

void visit_type_SnapshotInfo(Visitor *m, SnapshotInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "SnapshotInfo", name, sizeof(SnapshotInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_SnapshotInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_SnapshotInfoList(Visitor *m, SnapshotInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                SnapshotInfoList *native_i = (SnapshotInfoList *)i;
                visit_type_SnapshotInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ImageInfoSpecificQCow2_fields(Visitor *m, ImageInfoSpecificQCow2 ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->compat : NULL, "compat", &err);
    visit_start_optional(m, obj ? &(*obj)->has_lazy_refcounts : NULL, "lazy-refcounts", &err);
    if (obj && (*obj)->has_lazy_refcounts) {
        visit_type_bool(m, obj ? &(*obj)->lazy_refcounts : NULL, "lazy-refcounts", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_ImageInfoSpecificQCow2(Visitor *m, ImageInfoSpecificQCow2 ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ImageInfoSpecificQCow2", name, sizeof(ImageInfoSpecificQCow2), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ImageInfoSpecificQCow2_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ImageInfoSpecificQCow2List(Visitor *m, ImageInfoSpecificQCow2List ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ImageInfoSpecificQCow2List *native_i = (ImageInfoSpecificQCow2List *)i;
                visit_type_ImageInfoSpecificQCow2(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ImageInfoSpecificVmdk_fields(Visitor *m, ImageInfoSpecificVmdk ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->create_type : NULL, "create-type", &err);
    visit_type_int(m, obj ? &(*obj)->cid : NULL, "cid", &err);
    visit_type_int(m, obj ? &(*obj)->parent_cid : NULL, "parent-cid", &err);
    visit_type_ImageInfoList(m, obj ? &(*obj)->extents : NULL, "extents", &err);

    error_propagate(errp, err);
}

void visit_type_ImageInfoSpecificVmdk(Visitor *m, ImageInfoSpecificVmdk ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ImageInfoSpecificVmdk", name, sizeof(ImageInfoSpecificVmdk), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ImageInfoSpecificVmdk_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ImageInfoSpecificVmdkList(Visitor *m, ImageInfoSpecificVmdkList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ImageInfoSpecificVmdkList *native_i = (ImageInfoSpecificVmdkList *)i;
                visit_type_ImageInfoSpecificVmdk(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ImageInfoSpecificKind(Visitor *m, ImageInfoSpecificKind * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, ImageInfoSpecificKind_lookup, "ImageInfoSpecificKind", name, errp);
}

void visit_type_ImageInfoSpecific(Visitor *m, ImageInfoSpecific ** obj, const char *name, Error **errp)
{
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_struct(m, (void **)obj, "ImageInfoSpecific", name, sizeof(ImageInfoSpecific), &err);
        if (!err) {
            if (obj && *obj) {
                visit_type_ImageInfoSpecificKind(m, &(*obj)->kind, "type", &err);
                if (!err) {
                    switch ((*obj)->kind) {
                    case IMAGE_INFO_SPECIFIC_KIND_QCOW2:
                        visit_type_ImageInfoSpecificQCow2(m, &(*obj)->qcow2, "data", &err);
                        break;
                    case IMAGE_INFO_SPECIFIC_KIND_VMDK:
                        visit_type_ImageInfoSpecificVmdk(m, &(*obj)->vmdk, "data", &err);
                        break;
                    default:
                        abort();
                    }
                }
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ImageInfoSpecificList(Visitor *m, ImageInfoSpecificList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ImageInfoSpecificList *native_i = (ImageInfoSpecificList *)i;
                visit_type_ImageInfoSpecific(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ImageInfo_fields(Visitor *m, ImageInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->filename : NULL, "filename", &err);
    visit_type_str(m, obj ? &(*obj)->format : NULL, "format", &err);
    visit_start_optional(m, obj ? &(*obj)->has_dirty_flag : NULL, "dirty-flag", &err);
    if (obj && (*obj)->has_dirty_flag) {
        visit_type_bool(m, obj ? &(*obj)->dirty_flag : NULL, "dirty-flag", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_actual_size : NULL, "actual-size", &err);
    if (obj && (*obj)->has_actual_size) {
        visit_type_int(m, obj ? &(*obj)->actual_size : NULL, "actual-size", &err);
    }
    visit_end_optional(m, &err);
    visit_type_int(m, obj ? &(*obj)->virtual_size : NULL, "virtual-size", &err);
    visit_start_optional(m, obj ? &(*obj)->has_cluster_size : NULL, "cluster-size", &err);
    if (obj && (*obj)->has_cluster_size) {
        visit_type_int(m, obj ? &(*obj)->cluster_size : NULL, "cluster-size", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_encrypted : NULL, "encrypted", &err);
    if (obj && (*obj)->has_encrypted) {
        visit_type_bool(m, obj ? &(*obj)->encrypted : NULL, "encrypted", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_compressed : NULL, "compressed", &err);
    if (obj && (*obj)->has_compressed) {
        visit_type_bool(m, obj ? &(*obj)->compressed : NULL, "compressed", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_backing_filename : NULL, "backing-filename", &err);
    if (obj && (*obj)->has_backing_filename) {
        visit_type_str(m, obj ? &(*obj)->backing_filename : NULL, "backing-filename", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_full_backing_filename : NULL, "full-backing-filename", &err);
    if (obj && (*obj)->has_full_backing_filename) {
        visit_type_str(m, obj ? &(*obj)->full_backing_filename : NULL, "full-backing-filename", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_backing_filename_format : NULL, "backing-filename-format", &err);
    if (obj && (*obj)->has_backing_filename_format) {
        visit_type_str(m, obj ? &(*obj)->backing_filename_format : NULL, "backing-filename-format", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_snapshots : NULL, "snapshots", &err);
    if (obj && (*obj)->has_snapshots) {
        visit_type_SnapshotInfoList(m, obj ? &(*obj)->snapshots : NULL, "snapshots", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_backing_image : NULL, "backing-image", &err);
    if (obj && (*obj)->has_backing_image) {
        visit_type_ImageInfo(m, obj ? &(*obj)->backing_image : NULL, "backing-image", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_format_specific : NULL, "format-specific", &err);
    if (obj && (*obj)->has_format_specific) {
        visit_type_ImageInfoSpecific(m, obj ? &(*obj)->format_specific : NULL, "format-specific", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_ImageInfo(Visitor *m, ImageInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ImageInfo", name, sizeof(ImageInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ImageInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ImageInfoList(Visitor *m, ImageInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ImageInfoList *native_i = (ImageInfoList *)i;
                visit_type_ImageInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ImageCheck_fields(Visitor *m, ImageCheck ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->filename : NULL, "filename", &err);
    visit_type_str(m, obj ? &(*obj)->format : NULL, "format", &err);
    visit_type_int(m, obj ? &(*obj)->check_errors : NULL, "check-errors", &err);
    visit_start_optional(m, obj ? &(*obj)->has_image_end_offset : NULL, "image-end-offset", &err);
    if (obj && (*obj)->has_image_end_offset) {
        visit_type_int(m, obj ? &(*obj)->image_end_offset : NULL, "image-end-offset", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_corruptions : NULL, "corruptions", &err);
    if (obj && (*obj)->has_corruptions) {
        visit_type_int(m, obj ? &(*obj)->corruptions : NULL, "corruptions", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_leaks : NULL, "leaks", &err);
    if (obj && (*obj)->has_leaks) {
        visit_type_int(m, obj ? &(*obj)->leaks : NULL, "leaks", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_corruptions_fixed : NULL, "corruptions-fixed", &err);
    if (obj && (*obj)->has_corruptions_fixed) {
        visit_type_int(m, obj ? &(*obj)->corruptions_fixed : NULL, "corruptions-fixed", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_leaks_fixed : NULL, "leaks-fixed", &err);
    if (obj && (*obj)->has_leaks_fixed) {
        visit_type_int(m, obj ? &(*obj)->leaks_fixed : NULL, "leaks-fixed", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_total_clusters : NULL, "total-clusters", &err);
    if (obj && (*obj)->has_total_clusters) {
        visit_type_int(m, obj ? &(*obj)->total_clusters : NULL, "total-clusters", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_allocated_clusters : NULL, "allocated-clusters", &err);
    if (obj && (*obj)->has_allocated_clusters) {
        visit_type_int(m, obj ? &(*obj)->allocated_clusters : NULL, "allocated-clusters", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_fragmented_clusters : NULL, "fragmented-clusters", &err);
    if (obj && (*obj)->has_fragmented_clusters) {
        visit_type_int(m, obj ? &(*obj)->fragmented_clusters : NULL, "fragmented-clusters", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_compressed_clusters : NULL, "compressed-clusters", &err);
    if (obj && (*obj)->has_compressed_clusters) {
        visit_type_int(m, obj ? &(*obj)->compressed_clusters : NULL, "compressed-clusters", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_ImageCheck(Visitor *m, ImageCheck ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ImageCheck", name, sizeof(ImageCheck), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ImageCheck_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ImageCheckList(Visitor *m, ImageCheckList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ImageCheckList *native_i = (ImageCheckList *)i;
                visit_type_ImageCheck(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_StatusInfo_fields(Visitor *m, StatusInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_bool(m, obj ? &(*obj)->running : NULL, "running", &err);
    visit_type_bool(m, obj ? &(*obj)->singlestep : NULL, "singlestep", &err);
    visit_type_RunState(m, obj ? &(*obj)->status : NULL, "status", &err);

    error_propagate(errp, err);
}

void visit_type_StatusInfo(Visitor *m, StatusInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "StatusInfo", name, sizeof(StatusInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_StatusInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_StatusInfoList(Visitor *m, StatusInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                StatusInfoList *native_i = (StatusInfoList *)i;
                visit_type_StatusInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_UuidInfo_fields(Visitor *m, UuidInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->UUID : NULL, "UUID", &err);

    error_propagate(errp, err);
}

void visit_type_UuidInfo(Visitor *m, UuidInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "UuidInfo", name, sizeof(UuidInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_UuidInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_UuidInfoList(Visitor *m, UuidInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                UuidInfoList *native_i = (UuidInfoList *)i;
                visit_type_UuidInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ChardevInfo_fields(Visitor *m, ChardevInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->label : NULL, "label", &err);
    visit_type_str(m, obj ? &(*obj)->filename : NULL, "filename", &err);

    error_propagate(errp, err);
}

void visit_type_ChardevInfo(Visitor *m, ChardevInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevInfo", name, sizeof(ChardevInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevInfoList(Visitor *m, ChardevInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevInfoList *native_i = (ChardevInfoList *)i;
                visit_type_ChardevInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_DataFormatList(Visitor *m, DataFormatList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                DataFormatList *native_i = (DataFormatList *)i;
                visit_type_DataFormat(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_DataFormat(Visitor *m, DataFormat * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, DataFormat_lookup, "DataFormat", name, errp);
}

static void visit_type_CommandInfo_fields(Visitor *m, CommandInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);

    error_propagate(errp, err);
}

void visit_type_CommandInfo(Visitor *m, CommandInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "CommandInfo", name, sizeof(CommandInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_CommandInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_CommandInfoList(Visitor *m, CommandInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                CommandInfoList *native_i = (CommandInfoList *)i;
                visit_type_CommandInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_EventInfo_fields(Visitor *m, EventInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);

    error_propagate(errp, err);
}

void visit_type_EventInfo(Visitor *m, EventInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "EventInfo", name, sizeof(EventInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_EventInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_EventInfoList(Visitor *m, EventInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                EventInfoList *native_i = (EventInfoList *)i;
                visit_type_EventInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_MigrationStats_fields(Visitor *m, MigrationStats ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->transferred : NULL, "transferred", &err);
    visit_type_int(m, obj ? &(*obj)->remaining : NULL, "remaining", &err);
    visit_type_int(m, obj ? &(*obj)->total : NULL, "total", &err);
    visit_type_int(m, obj ? &(*obj)->duplicate : NULL, "duplicate", &err);
    visit_type_int(m, obj ? &(*obj)->skipped : NULL, "skipped", &err);
    visit_type_int(m, obj ? &(*obj)->normal : NULL, "normal", &err);
    visit_type_int(m, obj ? &(*obj)->normal_bytes : NULL, "normal-bytes", &err);
    visit_type_int(m, obj ? &(*obj)->dirty_pages_rate : NULL, "dirty-pages-rate", &err);
    visit_type_number(m, obj ? &(*obj)->mbps : NULL, "mbps", &err);

    error_propagate(errp, err);
}

void visit_type_MigrationStats(Visitor *m, MigrationStats ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "MigrationStats", name, sizeof(MigrationStats), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_MigrationStats_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_MigrationStatsList(Visitor *m, MigrationStatsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                MigrationStatsList *native_i = (MigrationStatsList *)i;
                visit_type_MigrationStats(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_XBZRLECacheStats_fields(Visitor *m, XBZRLECacheStats ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->cache_size : NULL, "cache-size", &err);
    visit_type_int(m, obj ? &(*obj)->bytes : NULL, "bytes", &err);
    visit_type_int(m, obj ? &(*obj)->pages : NULL, "pages", &err);
    visit_type_int(m, obj ? &(*obj)->cache_miss : NULL, "cache-miss", &err);
    visit_type_int(m, obj ? &(*obj)->overflow : NULL, "overflow", &err);

    error_propagate(errp, err);
}

void visit_type_XBZRLECacheStats(Visitor *m, XBZRLECacheStats ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "XBZRLECacheStats", name, sizeof(XBZRLECacheStats), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_XBZRLECacheStats_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_XBZRLECacheStatsList(Visitor *m, XBZRLECacheStatsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                XBZRLECacheStatsList *native_i = (XBZRLECacheStatsList *)i;
                visit_type_XBZRLECacheStats(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_MigrationInfo_fields(Visitor *m, MigrationInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_status : NULL, "status", &err);
    if (obj && (*obj)->has_status) {
        visit_type_str(m, obj ? &(*obj)->status : NULL, "status", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_ram : NULL, "ram", &err);
    if (obj && (*obj)->has_ram) {
        visit_type_MigrationStats(m, obj ? &(*obj)->ram : NULL, "ram", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_disk : NULL, "disk", &err);
    if (obj && (*obj)->has_disk) {
        visit_type_MigrationStats(m, obj ? &(*obj)->disk : NULL, "disk", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_xbzrle_cache : NULL, "xbzrle-cache", &err);
    if (obj && (*obj)->has_xbzrle_cache) {
        visit_type_XBZRLECacheStats(m, obj ? &(*obj)->xbzrle_cache : NULL, "xbzrle-cache", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_total_time : NULL, "total-time", &err);
    if (obj && (*obj)->has_total_time) {
        visit_type_int(m, obj ? &(*obj)->total_time : NULL, "total-time", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_expected_downtime : NULL, "expected-downtime", &err);
    if (obj && (*obj)->has_expected_downtime) {
        visit_type_int(m, obj ? &(*obj)->expected_downtime : NULL, "expected-downtime", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_downtime : NULL, "downtime", &err);
    if (obj && (*obj)->has_downtime) {
        visit_type_int(m, obj ? &(*obj)->downtime : NULL, "downtime", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_setup_time : NULL, "setup-time", &err);
    if (obj && (*obj)->has_setup_time) {
        visit_type_int(m, obj ? &(*obj)->setup_time : NULL, "setup-time", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_MigrationInfo(Visitor *m, MigrationInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "MigrationInfo", name, sizeof(MigrationInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_MigrationInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_MigrationInfoList(Visitor *m, MigrationInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                MigrationInfoList *native_i = (MigrationInfoList *)i;
                visit_type_MigrationInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_MigrationCapabilityList(Visitor *m, MigrationCapabilityList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                MigrationCapabilityList *native_i = (MigrationCapabilityList *)i;
                visit_type_MigrationCapability(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_MigrationCapability(Visitor *m, MigrationCapability * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, MigrationCapability_lookup, "MigrationCapability", name, errp);
}

static void visit_type_MigrationCapabilityStatus_fields(Visitor *m, MigrationCapabilityStatus ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_MigrationCapability(m, obj ? &(*obj)->capability : NULL, "capability", &err);
    visit_type_bool(m, obj ? &(*obj)->state : NULL, "state", &err);

    error_propagate(errp, err);
}

void visit_type_MigrationCapabilityStatus(Visitor *m, MigrationCapabilityStatus ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "MigrationCapabilityStatus", name, sizeof(MigrationCapabilityStatus), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_MigrationCapabilityStatus_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_MigrationCapabilityStatusList(Visitor *m, MigrationCapabilityStatusList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                MigrationCapabilityStatusList *native_i = (MigrationCapabilityStatusList *)i;
                visit_type_MigrationCapabilityStatus(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_MouseInfo_fields(Visitor *m, MouseInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);
    visit_type_int(m, obj ? &(*obj)->index : NULL, "index", &err);
    visit_type_bool(m, obj ? &(*obj)->current : NULL, "current", &err);
    visit_type_bool(m, obj ? &(*obj)->absolute : NULL, "absolute", &err);

    error_propagate(errp, err);
}

void visit_type_MouseInfo(Visitor *m, MouseInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "MouseInfo", name, sizeof(MouseInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_MouseInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_MouseInfoList(Visitor *m, MouseInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                MouseInfoList *native_i = (MouseInfoList *)i;
                visit_type_MouseInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_CpuInfo_fields(Visitor *m, CpuInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->CPU : NULL, "CPU", &err);
    visit_type_bool(m, obj ? &(*obj)->current : NULL, "current", &err);
    visit_type_bool(m, obj ? &(*obj)->halted : NULL, "halted", &err);
    visit_start_optional(m, obj ? &(*obj)->has_pc : NULL, "pc", &err);
    if (obj && (*obj)->has_pc) {
        visit_type_int(m, obj ? &(*obj)->pc : NULL, "pc", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_nip : NULL, "nip", &err);
    if (obj && (*obj)->has_nip) {
        visit_type_int(m, obj ? &(*obj)->nip : NULL, "nip", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_npc : NULL, "npc", &err);
    if (obj && (*obj)->has_npc) {
        visit_type_int(m, obj ? &(*obj)->npc : NULL, "npc", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_PC : NULL, "PC", &err);
    if (obj && (*obj)->has_PC) {
        visit_type_int(m, obj ? &(*obj)->PC : NULL, "PC", &err);
    }
    visit_end_optional(m, &err);
    visit_type_int(m, obj ? &(*obj)->thread_id : NULL, "thread_id", &err);

    error_propagate(errp, err);
}

void visit_type_CpuInfo(Visitor *m, CpuInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "CpuInfo", name, sizeof(CpuInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_CpuInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_CpuInfoList(Visitor *m, CpuInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                CpuInfoList *native_i = (CpuInfoList *)i;
                visit_type_CpuInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_BlockDeviceInfo_fields(Visitor *m, BlockDeviceInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->file : NULL, "file", &err);
    visit_type_bool(m, obj ? &(*obj)->ro : NULL, "ro", &err);
    visit_type_str(m, obj ? &(*obj)->drv : NULL, "drv", &err);
    visit_start_optional(m, obj ? &(*obj)->has_backing_file : NULL, "backing_file", &err);
    if (obj && (*obj)->has_backing_file) {
        visit_type_str(m, obj ? &(*obj)->backing_file : NULL, "backing_file", &err);
    }
    visit_end_optional(m, &err);
    visit_type_int(m, obj ? &(*obj)->backing_file_depth : NULL, "backing_file_depth", &err);
    visit_type_bool(m, obj ? &(*obj)->encrypted : NULL, "encrypted", &err);
    visit_type_bool(m, obj ? &(*obj)->encryption_key_missing : NULL, "encryption_key_missing", &err);
    visit_type_int(m, obj ? &(*obj)->bps : NULL, "bps", &err);
    visit_type_int(m, obj ? &(*obj)->bps_rd : NULL, "bps_rd", &err);
    visit_type_int(m, obj ? &(*obj)->bps_wr : NULL, "bps_wr", &err);
    visit_type_int(m, obj ? &(*obj)->iops : NULL, "iops", &err);
    visit_type_int(m, obj ? &(*obj)->iops_rd : NULL, "iops_rd", &err);
    visit_type_int(m, obj ? &(*obj)->iops_wr : NULL, "iops_wr", &err);
    visit_type_ImageInfo(m, obj ? &(*obj)->image : NULL, "image", &err);
    visit_start_optional(m, obj ? &(*obj)->has_bps_max : NULL, "bps_max", &err);
    if (obj && (*obj)->has_bps_max) {
        visit_type_int(m, obj ? &(*obj)->bps_max : NULL, "bps_max", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_bps_rd_max : NULL, "bps_rd_max", &err);
    if (obj && (*obj)->has_bps_rd_max) {
        visit_type_int(m, obj ? &(*obj)->bps_rd_max : NULL, "bps_rd_max", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_bps_wr_max : NULL, "bps_wr_max", &err);
    if (obj && (*obj)->has_bps_wr_max) {
        visit_type_int(m, obj ? &(*obj)->bps_wr_max : NULL, "bps_wr_max", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_iops_max : NULL, "iops_max", &err);
    if (obj && (*obj)->has_iops_max) {
        visit_type_int(m, obj ? &(*obj)->iops_max : NULL, "iops_max", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_iops_rd_max : NULL, "iops_rd_max", &err);
    if (obj && (*obj)->has_iops_rd_max) {
        visit_type_int(m, obj ? &(*obj)->iops_rd_max : NULL, "iops_rd_max", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_iops_wr_max : NULL, "iops_wr_max", &err);
    if (obj && (*obj)->has_iops_wr_max) {
        visit_type_int(m, obj ? &(*obj)->iops_wr_max : NULL, "iops_wr_max", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_iops_size : NULL, "iops_size", &err);
    if (obj && (*obj)->has_iops_size) {
        visit_type_int(m, obj ? &(*obj)->iops_size : NULL, "iops_size", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_BlockDeviceInfo(Visitor *m, BlockDeviceInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockDeviceInfo", name, sizeof(BlockDeviceInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockDeviceInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockDeviceInfoList(Visitor *m, BlockDeviceInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockDeviceInfoList *native_i = (BlockDeviceInfoList *)i;
                visit_type_BlockDeviceInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockDeviceIoStatusList(Visitor *m, BlockDeviceIoStatusList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockDeviceIoStatusList *native_i = (BlockDeviceIoStatusList *)i;
                visit_type_BlockDeviceIoStatus(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockDeviceIoStatus(Visitor *m, BlockDeviceIoStatus * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, BlockDeviceIoStatus_lookup, "BlockDeviceIoStatus", name, errp);
}

static void visit_type_BlockDeviceMapEntry_fields(Visitor *m, BlockDeviceMapEntry ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->start : NULL, "start", &err);
    visit_type_int(m, obj ? &(*obj)->length : NULL, "length", &err);
    visit_type_int(m, obj ? &(*obj)->depth : NULL, "depth", &err);
    visit_type_bool(m, obj ? &(*obj)->zero : NULL, "zero", &err);
    visit_type_bool(m, obj ? &(*obj)->data : NULL, "data", &err);
    visit_start_optional(m, obj ? &(*obj)->has_offset : NULL, "offset", &err);
    if (obj && (*obj)->has_offset) {
        visit_type_int(m, obj ? &(*obj)->offset : NULL, "offset", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_BlockDeviceMapEntry(Visitor *m, BlockDeviceMapEntry ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockDeviceMapEntry", name, sizeof(BlockDeviceMapEntry), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockDeviceMapEntry_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockDeviceMapEntryList(Visitor *m, BlockDeviceMapEntryList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockDeviceMapEntryList *native_i = (BlockDeviceMapEntryList *)i;
                visit_type_BlockDeviceMapEntry(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_BlockDirtyInfo_fields(Visitor *m, BlockDirtyInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->count : NULL, "count", &err);
    visit_type_int(m, obj ? &(*obj)->granularity : NULL, "granularity", &err);

    error_propagate(errp, err);
}

void visit_type_BlockDirtyInfo(Visitor *m, BlockDirtyInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockDirtyInfo", name, sizeof(BlockDirtyInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockDirtyInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockDirtyInfoList(Visitor *m, BlockDirtyInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockDirtyInfoList *native_i = (BlockDirtyInfoList *)i;
                visit_type_BlockDirtyInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_BlockInfo_fields(Visitor *m, BlockInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->device : NULL, "device", &err);
    visit_type_str(m, obj ? &(*obj)->type : NULL, "type", &err);
    visit_type_bool(m, obj ? &(*obj)->removable : NULL, "removable", &err);
    visit_type_bool(m, obj ? &(*obj)->locked : NULL, "locked", &err);
    visit_start_optional(m, obj ? &(*obj)->has_inserted : NULL, "inserted", &err);
    if (obj && (*obj)->has_inserted) {
        visit_type_BlockDeviceInfo(m, obj ? &(*obj)->inserted : NULL, "inserted", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_tray_open : NULL, "tray_open", &err);
    if (obj && (*obj)->has_tray_open) {
        visit_type_bool(m, obj ? &(*obj)->tray_open : NULL, "tray_open", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_io_status : NULL, "io-status", &err);
    if (obj && (*obj)->has_io_status) {
        visit_type_BlockDeviceIoStatus(m, obj ? &(*obj)->io_status : NULL, "io-status", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_dirty_bitmaps : NULL, "dirty-bitmaps", &err);
    if (obj && (*obj)->has_dirty_bitmaps) {
        visit_type_BlockDirtyInfoList(m, obj ? &(*obj)->dirty_bitmaps : NULL, "dirty-bitmaps", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_BlockInfo(Visitor *m, BlockInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockInfo", name, sizeof(BlockInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockInfoList(Visitor *m, BlockInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockInfoList *native_i = (BlockInfoList *)i;
                visit_type_BlockInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_BlockDeviceStats_fields(Visitor *m, BlockDeviceStats ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->rd_bytes : NULL, "rd_bytes", &err);
    visit_type_int(m, obj ? &(*obj)->wr_bytes : NULL, "wr_bytes", &err);
    visit_type_int(m, obj ? &(*obj)->rd_operations : NULL, "rd_operations", &err);
    visit_type_int(m, obj ? &(*obj)->wr_operations : NULL, "wr_operations", &err);
    visit_type_int(m, obj ? &(*obj)->flush_operations : NULL, "flush_operations", &err);
    visit_type_int(m, obj ? &(*obj)->flush_total_time_ns : NULL, "flush_total_time_ns", &err);
    visit_type_int(m, obj ? &(*obj)->wr_total_time_ns : NULL, "wr_total_time_ns", &err);
    visit_type_int(m, obj ? &(*obj)->rd_total_time_ns : NULL, "rd_total_time_ns", &err);
    visit_type_int(m, obj ? &(*obj)->wr_highest_offset : NULL, "wr_highest_offset", &err);

    error_propagate(errp, err);
}

void visit_type_BlockDeviceStats(Visitor *m, BlockDeviceStats ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockDeviceStats", name, sizeof(BlockDeviceStats), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockDeviceStats_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockDeviceStatsList(Visitor *m, BlockDeviceStatsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockDeviceStatsList *native_i = (BlockDeviceStatsList *)i;
                visit_type_BlockDeviceStats(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_BlockStats_fields(Visitor *m, BlockStats ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_device : NULL, "device", &err);
    if (obj && (*obj)->has_device) {
        visit_type_str(m, obj ? &(*obj)->device : NULL, "device", &err);
    }
    visit_end_optional(m, &err);
    visit_type_BlockDeviceStats(m, obj ? &(*obj)->stats : NULL, "stats", &err);
    visit_start_optional(m, obj ? &(*obj)->has_parent : NULL, "parent", &err);
    if (obj && (*obj)->has_parent) {
        visit_type_BlockStats(m, obj ? &(*obj)->parent : NULL, "parent", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_BlockStats(Visitor *m, BlockStats ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockStats", name, sizeof(BlockStats), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockStats_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockStatsList(Visitor *m, BlockStatsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockStatsList *native_i = (BlockStatsList *)i;
                visit_type_BlockStats(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_VncClientInfo_fields(Visitor *m, VncClientInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->host : NULL, "host", &err);
    visit_type_str(m, obj ? &(*obj)->family : NULL, "family", &err);
    visit_type_str(m, obj ? &(*obj)->service : NULL, "service", &err);
    visit_start_optional(m, obj ? &(*obj)->has_x509_dname : NULL, "x509_dname", &err);
    if (obj && (*obj)->has_x509_dname) {
        visit_type_str(m, obj ? &(*obj)->x509_dname : NULL, "x509_dname", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_sasl_username : NULL, "sasl_username", &err);
    if (obj && (*obj)->has_sasl_username) {
        visit_type_str(m, obj ? &(*obj)->sasl_username : NULL, "sasl_username", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_VncClientInfo(Visitor *m, VncClientInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "VncClientInfo", name, sizeof(VncClientInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_VncClientInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_VncClientInfoList(Visitor *m, VncClientInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                VncClientInfoList *native_i = (VncClientInfoList *)i;
                visit_type_VncClientInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_VncInfo_fields(Visitor *m, VncInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_bool(m, obj ? &(*obj)->enabled : NULL, "enabled", &err);
    visit_start_optional(m, obj ? &(*obj)->has_host : NULL, "host", &err);
    if (obj && (*obj)->has_host) {
        visit_type_str(m, obj ? &(*obj)->host : NULL, "host", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_family : NULL, "family", &err);
    if (obj && (*obj)->has_family) {
        visit_type_str(m, obj ? &(*obj)->family : NULL, "family", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_service : NULL, "service", &err);
    if (obj && (*obj)->has_service) {
        visit_type_str(m, obj ? &(*obj)->service : NULL, "service", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_auth : NULL, "auth", &err);
    if (obj && (*obj)->has_auth) {
        visit_type_str(m, obj ? &(*obj)->auth : NULL, "auth", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_clients : NULL, "clients", &err);
    if (obj && (*obj)->has_clients) {
        visit_type_VncClientInfoList(m, obj ? &(*obj)->clients : NULL, "clients", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_VncInfo(Visitor *m, VncInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "VncInfo", name, sizeof(VncInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_VncInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_VncInfoList(Visitor *m, VncInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                VncInfoList *native_i = (VncInfoList *)i;
                visit_type_VncInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_SpiceChannel_fields(Visitor *m, SpiceChannel ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->host : NULL, "host", &err);
    visit_type_str(m, obj ? &(*obj)->family : NULL, "family", &err);
    visit_type_str(m, obj ? &(*obj)->port : NULL, "port", &err);
    visit_type_int(m, obj ? &(*obj)->connection_id : NULL, "connection-id", &err);
    visit_type_int(m, obj ? &(*obj)->channel_type : NULL, "channel-type", &err);
    visit_type_int(m, obj ? &(*obj)->channel_id : NULL, "channel-id", &err);
    visit_type_bool(m, obj ? &(*obj)->tls : NULL, "tls", &err);

    error_propagate(errp, err);
}

void visit_type_SpiceChannel(Visitor *m, SpiceChannel ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "SpiceChannel", name, sizeof(SpiceChannel), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_SpiceChannel_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_SpiceChannelList(Visitor *m, SpiceChannelList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                SpiceChannelList *native_i = (SpiceChannelList *)i;
                visit_type_SpiceChannel(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_SpiceQueryMouseModeList(Visitor *m, SpiceQueryMouseModeList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                SpiceQueryMouseModeList *native_i = (SpiceQueryMouseModeList *)i;
                visit_type_SpiceQueryMouseMode(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_SpiceQueryMouseMode(Visitor *m, SpiceQueryMouseMode * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, SpiceQueryMouseMode_lookup, "SpiceQueryMouseMode", name, errp);
}

static void visit_type_SpiceInfo_fields(Visitor *m, SpiceInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_bool(m, obj ? &(*obj)->enabled : NULL, "enabled", &err);
    visit_type_bool(m, obj ? &(*obj)->migrated : NULL, "migrated", &err);
    visit_start_optional(m, obj ? &(*obj)->has_host : NULL, "host", &err);
    if (obj && (*obj)->has_host) {
        visit_type_str(m, obj ? &(*obj)->host : NULL, "host", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_port : NULL, "port", &err);
    if (obj && (*obj)->has_port) {
        visit_type_int(m, obj ? &(*obj)->port : NULL, "port", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_tls_port : NULL, "tls-port", &err);
    if (obj && (*obj)->has_tls_port) {
        visit_type_int(m, obj ? &(*obj)->tls_port : NULL, "tls-port", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_auth : NULL, "auth", &err);
    if (obj && (*obj)->has_auth) {
        visit_type_str(m, obj ? &(*obj)->auth : NULL, "auth", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_compiled_version : NULL, "compiled-version", &err);
    if (obj && (*obj)->has_compiled_version) {
        visit_type_str(m, obj ? &(*obj)->compiled_version : NULL, "compiled-version", &err);
    }
    visit_end_optional(m, &err);
    visit_type_SpiceQueryMouseMode(m, obj ? &(*obj)->mouse_mode : NULL, "mouse-mode", &err);
    visit_start_optional(m, obj ? &(*obj)->has_channels : NULL, "channels", &err);
    if (obj && (*obj)->has_channels) {
        visit_type_SpiceChannelList(m, obj ? &(*obj)->channels : NULL, "channels", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_SpiceInfo(Visitor *m, SpiceInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "SpiceInfo", name, sizeof(SpiceInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_SpiceInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_SpiceInfoList(Visitor *m, SpiceInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                SpiceInfoList *native_i = (SpiceInfoList *)i;
                visit_type_SpiceInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_BalloonInfo_fields(Visitor *m, BalloonInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->actual : NULL, "actual", &err);

    error_propagate(errp, err);
}

void visit_type_BalloonInfo(Visitor *m, BalloonInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BalloonInfo", name, sizeof(BalloonInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BalloonInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BalloonInfoList(Visitor *m, BalloonInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BalloonInfoList *native_i = (BalloonInfoList *)i;
                visit_type_BalloonInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_PciMemoryRange_fields(Visitor *m, PciMemoryRange ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->base : NULL, "base", &err);
    visit_type_int(m, obj ? &(*obj)->limit : NULL, "limit", &err);

    error_propagate(errp, err);
}

void visit_type_PciMemoryRange(Visitor *m, PciMemoryRange ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "PciMemoryRange", name, sizeof(PciMemoryRange), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_PciMemoryRange_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_PciMemoryRangeList(Visitor *m, PciMemoryRangeList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                PciMemoryRangeList *native_i = (PciMemoryRangeList *)i;
                visit_type_PciMemoryRange(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_PciMemoryRegion_fields(Visitor *m, PciMemoryRegion ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->bar : NULL, "bar", &err);
    visit_type_str(m, obj ? &(*obj)->type : NULL, "type", &err);
    visit_type_int(m, obj ? &(*obj)->address : NULL, "address", &err);
    visit_type_int(m, obj ? &(*obj)->size : NULL, "size", &err);
    visit_start_optional(m, obj ? &(*obj)->has_prefetch : NULL, "prefetch", &err);
    if (obj && (*obj)->has_prefetch) {
        visit_type_bool(m, obj ? &(*obj)->prefetch : NULL, "prefetch", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_mem_type_64 : NULL, "mem_type_64", &err);
    if (obj && (*obj)->has_mem_type_64) {
        visit_type_bool(m, obj ? &(*obj)->mem_type_64 : NULL, "mem_type_64", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_PciMemoryRegion(Visitor *m, PciMemoryRegion ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "PciMemoryRegion", name, sizeof(PciMemoryRegion), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_PciMemoryRegion_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_PciMemoryRegionList(Visitor *m, PciMemoryRegionList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                PciMemoryRegionList *native_i = (PciMemoryRegionList *)i;
                visit_type_PciMemoryRegion(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_PciBridgeInfo_bus_fields(Visitor *m, PciBridgeInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->bus.number : NULL, "number", &err);
    visit_type_int(m, obj ? &(*obj)->bus.secondary : NULL, "secondary", &err);
    visit_type_int(m, obj ? &(*obj)->bus.subordinate : NULL, "subordinate", &err);
    visit_type_PciMemoryRange(m, obj ? &(*obj)->bus.io_range : NULL, "io_range", &err);
    visit_type_PciMemoryRange(m, obj ? &(*obj)->bus.memory_range : NULL, "memory_range", &err);
    visit_type_PciMemoryRange(m, obj ? &(*obj)->bus.prefetchable_range : NULL, "prefetchable_range", &err);

    error_propagate(errp, err);
}

static void visit_type_PciBridgeInfo_fields(Visitor *m, PciBridgeInfo ** obj, Error **errp)
{
    Error *err = NULL;
    if (!error_is_set(errp)) {
        Error **errp = &err; /* from outer scope */
        Error *err = NULL;
        visit_start_struct(m, NULL, "", "bus", 0, &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_PciBridgeInfo_bus_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
    visit_start_optional(m, obj ? &(*obj)->has_devices : NULL, "devices", &err);
    if (obj && (*obj)->has_devices) {
        visit_type_PciDeviceInfoList(m, obj ? &(*obj)->devices : NULL, "devices", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_PciBridgeInfo(Visitor *m, PciBridgeInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "PciBridgeInfo", name, sizeof(PciBridgeInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_PciBridgeInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_PciBridgeInfoList(Visitor *m, PciBridgeInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                PciBridgeInfoList *native_i = (PciBridgeInfoList *)i;
                visit_type_PciBridgeInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_PciDeviceInfo_class_info_fields(Visitor *m, PciDeviceInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->class_info.has_desc : NULL, "desc", &err);
    if (obj && (*obj)->class_info.has_desc) {
        visit_type_str(m, obj ? &(*obj)->class_info.desc : NULL, "desc", &err);
    }
    visit_end_optional(m, &err);
    visit_type_int(m, obj ? &(*obj)->class_info.q_class : NULL, "class", &err);

    error_propagate(errp, err);
}

static void visit_type_PciDeviceInfo_id_fields(Visitor *m, PciDeviceInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->id.device : NULL, "device", &err);
    visit_type_int(m, obj ? &(*obj)->id.vendor : NULL, "vendor", &err);

    error_propagate(errp, err);
}

static void visit_type_PciDeviceInfo_fields(Visitor *m, PciDeviceInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->bus : NULL, "bus", &err);
    visit_type_int(m, obj ? &(*obj)->slot : NULL, "slot", &err);
    visit_type_int(m, obj ? &(*obj)->function : NULL, "function", &err);
    if (!error_is_set(errp)) {
        Error **errp = &err; /* from outer scope */
        Error *err = NULL;
        visit_start_struct(m, NULL, "", "class_info", 0, &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_PciDeviceInfo_class_info_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
    if (!error_is_set(errp)) {
        Error **errp = &err; /* from outer scope */
        Error *err = NULL;
        visit_start_struct(m, NULL, "", "id", 0, &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_PciDeviceInfo_id_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
    visit_start_optional(m, obj ? &(*obj)->has_irq : NULL, "irq", &err);
    if (obj && (*obj)->has_irq) {
        visit_type_int(m, obj ? &(*obj)->irq : NULL, "irq", &err);
    }
    visit_end_optional(m, &err);
    visit_type_str(m, obj ? &(*obj)->qdev_id : NULL, "qdev_id", &err);
    visit_start_optional(m, obj ? &(*obj)->has_pci_bridge : NULL, "pci_bridge", &err);
    if (obj && (*obj)->has_pci_bridge) {
        visit_type_PciBridgeInfo(m, obj ? &(*obj)->pci_bridge : NULL, "pci_bridge", &err);
    }
    visit_end_optional(m, &err);
    visit_type_PciMemoryRegionList(m, obj ? &(*obj)->regions : NULL, "regions", &err);

    error_propagate(errp, err);
}

void visit_type_PciDeviceInfo(Visitor *m, PciDeviceInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "PciDeviceInfo", name, sizeof(PciDeviceInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_PciDeviceInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_PciDeviceInfoList(Visitor *m, PciDeviceInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                PciDeviceInfoList *native_i = (PciDeviceInfoList *)i;
                visit_type_PciDeviceInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_PciInfo_fields(Visitor *m, PciInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->bus : NULL, "bus", &err);
    visit_type_PciDeviceInfoList(m, obj ? &(*obj)->devices : NULL, "devices", &err);

    error_propagate(errp, err);
}

void visit_type_PciInfo(Visitor *m, PciInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "PciInfo", name, sizeof(PciInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_PciInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_PciInfoList(Visitor *m, PciInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                PciInfoList *native_i = (PciInfoList *)i;
                visit_type_PciInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevOnErrorList(Visitor *m, BlockdevOnErrorList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevOnErrorList *native_i = (BlockdevOnErrorList *)i;
                visit_type_BlockdevOnError(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevOnError(Visitor *m, BlockdevOnError * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, BlockdevOnError_lookup, "BlockdevOnError", name, errp);
}

void visit_type_MirrorSyncModeList(Visitor *m, MirrorSyncModeList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                MirrorSyncModeList *native_i = (MirrorSyncModeList *)i;
                visit_type_MirrorSyncMode(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_MirrorSyncMode(Visitor *m, MirrorSyncMode * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, MirrorSyncMode_lookup, "MirrorSyncMode", name, errp);
}

void visit_type_BlockJobTypeList(Visitor *m, BlockJobTypeList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockJobTypeList *native_i = (BlockJobTypeList *)i;
                visit_type_BlockJobType(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockJobType(Visitor *m, BlockJobType * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, BlockJobType_lookup, "BlockJobType", name, errp);
}

static void visit_type_BlockJobInfo_fields(Visitor *m, BlockJobInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->type : NULL, "type", &err);
    visit_type_str(m, obj ? &(*obj)->device : NULL, "device", &err);
    visit_type_int(m, obj ? &(*obj)->len : NULL, "len", &err);
    visit_type_int(m, obj ? &(*obj)->offset : NULL, "offset", &err);
    visit_type_bool(m, obj ? &(*obj)->busy : NULL, "busy", &err);
    visit_type_bool(m, obj ? &(*obj)->paused : NULL, "paused", &err);
    visit_type_int(m, obj ? &(*obj)->speed : NULL, "speed", &err);
    visit_type_BlockDeviceIoStatus(m, obj ? &(*obj)->io_status : NULL, "io-status", &err);

    error_propagate(errp, err);
}

void visit_type_BlockJobInfo(Visitor *m, BlockJobInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockJobInfo", name, sizeof(BlockJobInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockJobInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockJobInfoList(Visitor *m, BlockJobInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockJobInfoList *native_i = (BlockJobInfoList *)i;
                visit_type_BlockJobInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NewImageModeList(Visitor *m, NewImageModeList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NewImageModeList *native_i = (NewImageModeList *)i;
                visit_type_NewImageMode(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NewImageMode(Visitor *m, NewImageMode * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, NewImageMode_lookup, "NewImageMode", name, errp);
}

static void visit_type_BlockdevSnapshot_fields(Visitor *m, BlockdevSnapshot ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->device : NULL, "device", &err);
    visit_type_str(m, obj ? &(*obj)->snapshot_file : NULL, "snapshot-file", &err);
    visit_start_optional(m, obj ? &(*obj)->has_format : NULL, "format", &err);
    if (obj && (*obj)->has_format) {
        visit_type_str(m, obj ? &(*obj)->format : NULL, "format", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_mode : NULL, "mode", &err);
    if (obj && (*obj)->has_mode) {
        visit_type_NewImageMode(m, obj ? &(*obj)->mode : NULL, "mode", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_BlockdevSnapshot(Visitor *m, BlockdevSnapshot ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockdevSnapshot", name, sizeof(BlockdevSnapshot), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockdevSnapshot_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevSnapshotList(Visitor *m, BlockdevSnapshotList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevSnapshotList *native_i = (BlockdevSnapshotList *)i;
                visit_type_BlockdevSnapshot(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_BlockdevSnapshotInternal_fields(Visitor *m, BlockdevSnapshotInternal ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->device : NULL, "device", &err);
    visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);

    error_propagate(errp, err);
}

void visit_type_BlockdevSnapshotInternal(Visitor *m, BlockdevSnapshotInternal ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockdevSnapshotInternal", name, sizeof(BlockdevSnapshotInternal), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockdevSnapshotInternal_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevSnapshotInternalList(Visitor *m, BlockdevSnapshotInternalList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevSnapshotInternalList *native_i = (BlockdevSnapshotInternalList *)i;
                visit_type_BlockdevSnapshotInternal(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_DriveBackup_fields(Visitor *m, DriveBackup ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->device : NULL, "device", &err);
    visit_type_str(m, obj ? &(*obj)->target : NULL, "target", &err);
    visit_start_optional(m, obj ? &(*obj)->has_format : NULL, "format", &err);
    if (obj && (*obj)->has_format) {
        visit_type_str(m, obj ? &(*obj)->format : NULL, "format", &err);
    }
    visit_end_optional(m, &err);
    visit_type_MirrorSyncMode(m, obj ? &(*obj)->sync : NULL, "sync", &err);
    visit_start_optional(m, obj ? &(*obj)->has_mode : NULL, "mode", &err);
    if (obj && (*obj)->has_mode) {
        visit_type_NewImageMode(m, obj ? &(*obj)->mode : NULL, "mode", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_speed : NULL, "speed", &err);
    if (obj && (*obj)->has_speed) {
        visit_type_int(m, obj ? &(*obj)->speed : NULL, "speed", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_on_source_error : NULL, "on-source-error", &err);
    if (obj && (*obj)->has_on_source_error) {
        visit_type_BlockdevOnError(m, obj ? &(*obj)->on_source_error : NULL, "on-source-error", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_on_target_error : NULL, "on-target-error", &err);
    if (obj && (*obj)->has_on_target_error) {
        visit_type_BlockdevOnError(m, obj ? &(*obj)->on_target_error : NULL, "on-target-error", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_DriveBackup(Visitor *m, DriveBackup ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "DriveBackup", name, sizeof(DriveBackup), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_DriveBackup_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_DriveBackupList(Visitor *m, DriveBackupList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                DriveBackupList *native_i = (DriveBackupList *)i;
                visit_type_DriveBackup(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_Abort_fields(Visitor *m, Abort ** obj, Error **errp)
{
    Error *err = NULL;

    error_propagate(errp, err);
}

void visit_type_Abort(Visitor *m, Abort ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "Abort", name, sizeof(Abort), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_Abort_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_AbortList(Visitor *m, AbortList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                AbortList *native_i = (AbortList *)i;
                visit_type_Abort(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_TransactionActionKind(Visitor *m, TransactionActionKind * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, TransactionActionKind_lookup, "TransactionActionKind", name, errp);
}

void visit_type_TransactionAction(Visitor *m, TransactionAction ** obj, const char *name, Error **errp)
{
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_struct(m, (void **)obj, "TransactionAction", name, sizeof(TransactionAction), &err);
        if (!err) {
            if (obj && *obj) {
                visit_type_TransactionActionKind(m, &(*obj)->kind, "type", &err);
                if (!err) {
                    switch ((*obj)->kind) {
                    case TRANSACTION_ACTION_KIND_BLOCKDEV_SNAPSHOT_SYNC:
                        visit_type_BlockdevSnapshot(m, &(*obj)->blockdev_snapshot_sync, "data", &err);
                        break;
                    case TRANSACTION_ACTION_KIND_DRIVE_BACKUP:
                        visit_type_DriveBackup(m, &(*obj)->drive_backup, "data", &err);
                        break;
                    case TRANSACTION_ACTION_KIND_ABORT:
                        visit_type_Abort(m, &(*obj)->abort, "data", &err);
                        break;
                    case TRANSACTION_ACTION_KIND_BLOCKDEV_SNAPSHOT_INTERNAL_SYNC:
                        visit_type_BlockdevSnapshotInternal(m, &(*obj)->blockdev_snapshot_internal_sync, "data", &err);
                        break;
                    default:
                        abort();
                    }
                }
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_TransactionActionList(Visitor *m, TransactionActionList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                TransactionActionList *native_i = (TransactionActionList *)i;
                visit_type_TransactionAction(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ObjectPropertyInfo_fields(Visitor *m, ObjectPropertyInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);
    visit_type_str(m, obj ? &(*obj)->type : NULL, "type", &err);

    error_propagate(errp, err);
}

void visit_type_ObjectPropertyInfo(Visitor *m, ObjectPropertyInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ObjectPropertyInfo", name, sizeof(ObjectPropertyInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ObjectPropertyInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ObjectPropertyInfoList(Visitor *m, ObjectPropertyInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ObjectPropertyInfoList *native_i = (ObjectPropertyInfoList *)i;
                visit_type_ObjectPropertyInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ObjectTypeInfo_fields(Visitor *m, ObjectTypeInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);

    error_propagate(errp, err);
}

void visit_type_ObjectTypeInfo(Visitor *m, ObjectTypeInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ObjectTypeInfo", name, sizeof(ObjectTypeInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ObjectTypeInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ObjectTypeInfoList(Visitor *m, ObjectTypeInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ObjectTypeInfoList *native_i = (ObjectTypeInfoList *)i;
                visit_type_ObjectTypeInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_DevicePropertyInfo_fields(Visitor *m, DevicePropertyInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);
    visit_type_str(m, obj ? &(*obj)->type : NULL, "type", &err);

    error_propagate(errp, err);
}

void visit_type_DevicePropertyInfo(Visitor *m, DevicePropertyInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "DevicePropertyInfo", name, sizeof(DevicePropertyInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_DevicePropertyInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_DevicePropertyInfoList(Visitor *m, DevicePropertyInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                DevicePropertyInfoList *native_i = (DevicePropertyInfoList *)i;
                visit_type_DevicePropertyInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_NetdevNoneOptions_fields(Visitor *m, NetdevNoneOptions ** obj, Error **errp)
{
    Error *err = NULL;

    error_propagate(errp, err);
}

void visit_type_NetdevNoneOptions(Visitor *m, NetdevNoneOptions ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "NetdevNoneOptions", name, sizeof(NetdevNoneOptions), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_NetdevNoneOptions_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetdevNoneOptionsList(Visitor *m, NetdevNoneOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NetdevNoneOptionsList *native_i = (NetdevNoneOptionsList *)i;
                visit_type_NetdevNoneOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_NetLegacyNicOptions_fields(Visitor *m, NetLegacyNicOptions ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_netdev : NULL, "netdev", &err);
    if (obj && (*obj)->has_netdev) {
        visit_type_str(m, obj ? &(*obj)->netdev : NULL, "netdev", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_macaddr : NULL, "macaddr", &err);
    if (obj && (*obj)->has_macaddr) {
        visit_type_str(m, obj ? &(*obj)->macaddr : NULL, "macaddr", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_model : NULL, "model", &err);
    if (obj && (*obj)->has_model) {
        visit_type_str(m, obj ? &(*obj)->model : NULL, "model", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_addr : NULL, "addr", &err);
    if (obj && (*obj)->has_addr) {
        visit_type_str(m, obj ? &(*obj)->addr : NULL, "addr", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_vectors : NULL, "vectors", &err);
    if (obj && (*obj)->has_vectors) {
        visit_type_uint32(m, obj ? &(*obj)->vectors : NULL, "vectors", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_NetLegacyNicOptions(Visitor *m, NetLegacyNicOptions ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "NetLegacyNicOptions", name, sizeof(NetLegacyNicOptions), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_NetLegacyNicOptions_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetLegacyNicOptionsList(Visitor *m, NetLegacyNicOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NetLegacyNicOptionsList *native_i = (NetLegacyNicOptionsList *)i;
                visit_type_NetLegacyNicOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_String_fields(Visitor *m, String ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->str : NULL, "str", &err);

    error_propagate(errp, err);
}

void visit_type_String(Visitor *m, String ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "String", name, sizeof(String), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_String_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_StringList(Visitor *m, StringList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                StringList *native_i = (StringList *)i;
                visit_type_String(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_NetdevUserOptions_fields(Visitor *m, NetdevUserOptions ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_hostname : NULL, "hostname", &err);
    if (obj && (*obj)->has_hostname) {
        visit_type_str(m, obj ? &(*obj)->hostname : NULL, "hostname", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_q_restrict : NULL, "restrict", &err);
    if (obj && (*obj)->has_q_restrict) {
        visit_type_bool(m, obj ? &(*obj)->q_restrict : NULL, "restrict", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_ip : NULL, "ip", &err);
    if (obj && (*obj)->has_ip) {
        visit_type_str(m, obj ? &(*obj)->ip : NULL, "ip", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_net : NULL, "net", &err);
    if (obj && (*obj)->has_net) {
        visit_type_str(m, obj ? &(*obj)->net : NULL, "net", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_host : NULL, "host", &err);
    if (obj && (*obj)->has_host) {
        visit_type_str(m, obj ? &(*obj)->host : NULL, "host", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_tftp : NULL, "tftp", &err);
    if (obj && (*obj)->has_tftp) {
        visit_type_str(m, obj ? &(*obj)->tftp : NULL, "tftp", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_bootfile : NULL, "bootfile", &err);
    if (obj && (*obj)->has_bootfile) {
        visit_type_str(m, obj ? &(*obj)->bootfile : NULL, "bootfile", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_dhcpstart : NULL, "dhcpstart", &err);
    if (obj && (*obj)->has_dhcpstart) {
        visit_type_str(m, obj ? &(*obj)->dhcpstart : NULL, "dhcpstart", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_dns : NULL, "dns", &err);
    if (obj && (*obj)->has_dns) {
        visit_type_str(m, obj ? &(*obj)->dns : NULL, "dns", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_dnssearch : NULL, "dnssearch", &err);
    if (obj && (*obj)->has_dnssearch) {
        visit_type_StringList(m, obj ? &(*obj)->dnssearch : NULL, "dnssearch", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_smb : NULL, "smb", &err);
    if (obj && (*obj)->has_smb) {
        visit_type_str(m, obj ? &(*obj)->smb : NULL, "smb", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_smbserver : NULL, "smbserver", &err);
    if (obj && (*obj)->has_smbserver) {
        visit_type_str(m, obj ? &(*obj)->smbserver : NULL, "smbserver", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_hostfwd : NULL, "hostfwd", &err);
    if (obj && (*obj)->has_hostfwd) {
        visit_type_StringList(m, obj ? &(*obj)->hostfwd : NULL, "hostfwd", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_guestfwd : NULL, "guestfwd", &err);
    if (obj && (*obj)->has_guestfwd) {
        visit_type_StringList(m, obj ? &(*obj)->guestfwd : NULL, "guestfwd", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_NetdevUserOptions(Visitor *m, NetdevUserOptions ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "NetdevUserOptions", name, sizeof(NetdevUserOptions), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_NetdevUserOptions_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetdevUserOptionsList(Visitor *m, NetdevUserOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NetdevUserOptionsList *native_i = (NetdevUserOptionsList *)i;
                visit_type_NetdevUserOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_NetdevTapOptions_fields(Visitor *m, NetdevTapOptions ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_ifname : NULL, "ifname", &err);
    if (obj && (*obj)->has_ifname) {
        visit_type_str(m, obj ? &(*obj)->ifname : NULL, "ifname", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_fd : NULL, "fd", &err);
    if (obj && (*obj)->has_fd) {
        visit_type_str(m, obj ? &(*obj)->fd : NULL, "fd", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_fds : NULL, "fds", &err);
    if (obj && (*obj)->has_fds) {
        visit_type_str(m, obj ? &(*obj)->fds : NULL, "fds", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_script : NULL, "script", &err);
    if (obj && (*obj)->has_script) {
        visit_type_str(m, obj ? &(*obj)->script : NULL, "script", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_downscript : NULL, "downscript", &err);
    if (obj && (*obj)->has_downscript) {
        visit_type_str(m, obj ? &(*obj)->downscript : NULL, "downscript", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_helper : NULL, "helper", &err);
    if (obj && (*obj)->has_helper) {
        visit_type_str(m, obj ? &(*obj)->helper : NULL, "helper", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_sndbuf : NULL, "sndbuf", &err);
    if (obj && (*obj)->has_sndbuf) {
        visit_type_size(m, obj ? &(*obj)->sndbuf : NULL, "sndbuf", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_vnet_hdr : NULL, "vnet_hdr", &err);
    if (obj && (*obj)->has_vnet_hdr) {
        visit_type_bool(m, obj ? &(*obj)->vnet_hdr : NULL, "vnet_hdr", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_vhost : NULL, "vhost", &err);
    if (obj && (*obj)->has_vhost) {
        visit_type_bool(m, obj ? &(*obj)->vhost : NULL, "vhost", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_vhostfd : NULL, "vhostfd", &err);
    if (obj && (*obj)->has_vhostfd) {
        visit_type_str(m, obj ? &(*obj)->vhostfd : NULL, "vhostfd", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_vhostfds : NULL, "vhostfds", &err);
    if (obj && (*obj)->has_vhostfds) {
        visit_type_str(m, obj ? &(*obj)->vhostfds : NULL, "vhostfds", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_vhostforce : NULL, "vhostforce", &err);
    if (obj && (*obj)->has_vhostforce) {
        visit_type_bool(m, obj ? &(*obj)->vhostforce : NULL, "vhostforce", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_queues : NULL, "queues", &err);
    if (obj && (*obj)->has_queues) {
        visit_type_uint32(m, obj ? &(*obj)->queues : NULL, "queues", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_NetdevTapOptions(Visitor *m, NetdevTapOptions ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "NetdevTapOptions", name, sizeof(NetdevTapOptions), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_NetdevTapOptions_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetdevTapOptionsList(Visitor *m, NetdevTapOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NetdevTapOptionsList *native_i = (NetdevTapOptionsList *)i;
                visit_type_NetdevTapOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_NetdevSocketOptions_fields(Visitor *m, NetdevSocketOptions ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_fd : NULL, "fd", &err);
    if (obj && (*obj)->has_fd) {
        visit_type_str(m, obj ? &(*obj)->fd : NULL, "fd", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_listen : NULL, "listen", &err);
    if (obj && (*obj)->has_listen) {
        visit_type_str(m, obj ? &(*obj)->listen : NULL, "listen", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_connect : NULL, "connect", &err);
    if (obj && (*obj)->has_connect) {
        visit_type_str(m, obj ? &(*obj)->connect : NULL, "connect", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_mcast : NULL, "mcast", &err);
    if (obj && (*obj)->has_mcast) {
        visit_type_str(m, obj ? &(*obj)->mcast : NULL, "mcast", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_localaddr : NULL, "localaddr", &err);
    if (obj && (*obj)->has_localaddr) {
        visit_type_str(m, obj ? &(*obj)->localaddr : NULL, "localaddr", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_udp : NULL, "udp", &err);
    if (obj && (*obj)->has_udp) {
        visit_type_str(m, obj ? &(*obj)->udp : NULL, "udp", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_NetdevSocketOptions(Visitor *m, NetdevSocketOptions ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "NetdevSocketOptions", name, sizeof(NetdevSocketOptions), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_NetdevSocketOptions_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetdevSocketOptionsList(Visitor *m, NetdevSocketOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NetdevSocketOptionsList *native_i = (NetdevSocketOptionsList *)i;
                visit_type_NetdevSocketOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_NetdevVdeOptions_fields(Visitor *m, NetdevVdeOptions ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_sock : NULL, "sock", &err);
    if (obj && (*obj)->has_sock) {
        visit_type_str(m, obj ? &(*obj)->sock : NULL, "sock", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_port : NULL, "port", &err);
    if (obj && (*obj)->has_port) {
        visit_type_uint16(m, obj ? &(*obj)->port : NULL, "port", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_group : NULL, "group", &err);
    if (obj && (*obj)->has_group) {
        visit_type_str(m, obj ? &(*obj)->group : NULL, "group", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_mode : NULL, "mode", &err);
    if (obj && (*obj)->has_mode) {
        visit_type_uint16(m, obj ? &(*obj)->mode : NULL, "mode", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_NetdevVdeOptions(Visitor *m, NetdevVdeOptions ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "NetdevVdeOptions", name, sizeof(NetdevVdeOptions), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_NetdevVdeOptions_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetdevVdeOptionsList(Visitor *m, NetdevVdeOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NetdevVdeOptionsList *native_i = (NetdevVdeOptionsList *)i;
                visit_type_NetdevVdeOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_NetdevDumpOptions_fields(Visitor *m, NetdevDumpOptions ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_len : NULL, "len", &err);
    if (obj && (*obj)->has_len) {
        visit_type_size(m, obj ? &(*obj)->len : NULL, "len", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_file : NULL, "file", &err);
    if (obj && (*obj)->has_file) {
        visit_type_str(m, obj ? &(*obj)->file : NULL, "file", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_NetdevDumpOptions(Visitor *m, NetdevDumpOptions ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "NetdevDumpOptions", name, sizeof(NetdevDumpOptions), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_NetdevDumpOptions_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetdevDumpOptionsList(Visitor *m, NetdevDumpOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NetdevDumpOptionsList *native_i = (NetdevDumpOptionsList *)i;
                visit_type_NetdevDumpOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_NetdevBridgeOptions_fields(Visitor *m, NetdevBridgeOptions ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_br : NULL, "br", &err);
    if (obj && (*obj)->has_br) {
        visit_type_str(m, obj ? &(*obj)->br : NULL, "br", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_helper : NULL, "helper", &err);
    if (obj && (*obj)->has_helper) {
        visit_type_str(m, obj ? &(*obj)->helper : NULL, "helper", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_NetdevBridgeOptions(Visitor *m, NetdevBridgeOptions ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "NetdevBridgeOptions", name, sizeof(NetdevBridgeOptions), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_NetdevBridgeOptions_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetdevBridgeOptionsList(Visitor *m, NetdevBridgeOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NetdevBridgeOptionsList *native_i = (NetdevBridgeOptionsList *)i;
                visit_type_NetdevBridgeOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_NetdevHubPortOptions_fields(Visitor *m, NetdevHubPortOptions ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int32(m, obj ? &(*obj)->hubid : NULL, "hubid", &err);

    error_propagate(errp, err);
}

void visit_type_NetdevHubPortOptions(Visitor *m, NetdevHubPortOptions ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "NetdevHubPortOptions", name, sizeof(NetdevHubPortOptions), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_NetdevHubPortOptions_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetdevHubPortOptionsList(Visitor *m, NetdevHubPortOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NetdevHubPortOptionsList *native_i = (NetdevHubPortOptionsList *)i;
                visit_type_NetdevHubPortOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_NetdevNetmapOptions_fields(Visitor *m, NetdevNetmapOptions ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->ifname : NULL, "ifname", &err);
    visit_start_optional(m, obj ? &(*obj)->has_devname : NULL, "devname", &err);
    if (obj && (*obj)->has_devname) {
        visit_type_str(m, obj ? &(*obj)->devname : NULL, "devname", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_NetdevNetmapOptions(Visitor *m, NetdevNetmapOptions ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "NetdevNetmapOptions", name, sizeof(NetdevNetmapOptions), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_NetdevNetmapOptions_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetdevNetmapOptionsList(Visitor *m, NetdevNetmapOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NetdevNetmapOptionsList *native_i = (NetdevNetmapOptionsList *)i;
                visit_type_NetdevNetmapOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetClientOptionsKind(Visitor *m, NetClientOptionsKind * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, NetClientOptionsKind_lookup, "NetClientOptionsKind", name, errp);
}

void visit_type_NetClientOptions(Visitor *m, NetClientOptions ** obj, const char *name, Error **errp)
{
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_struct(m, (void **)obj, "NetClientOptions", name, sizeof(NetClientOptions), &err);
        if (!err) {
            if (obj && *obj) {
                visit_type_NetClientOptionsKind(m, &(*obj)->kind, "type", &err);
                if (!err) {
                    switch ((*obj)->kind) {
                    case NET_CLIENT_OPTIONS_KIND_NONE:
                        visit_type_NetdevNoneOptions(m, &(*obj)->none, "data", &err);
                        break;
                    case NET_CLIENT_OPTIONS_KIND_NIC:
                        visit_type_NetLegacyNicOptions(m, &(*obj)->nic, "data", &err);
                        break;
                    case NET_CLIENT_OPTIONS_KIND_USER:
                        visit_type_NetdevUserOptions(m, &(*obj)->user, "data", &err);
                        break;
                    case NET_CLIENT_OPTIONS_KIND_TAP:
                        visit_type_NetdevTapOptions(m, &(*obj)->tap, "data", &err);
                        break;
                    case NET_CLIENT_OPTIONS_KIND_SOCKET:
                        visit_type_NetdevSocketOptions(m, &(*obj)->socket, "data", &err);
                        break;
                    case NET_CLIENT_OPTIONS_KIND_VDE:
                        visit_type_NetdevVdeOptions(m, &(*obj)->vde, "data", &err);
                        break;
                    case NET_CLIENT_OPTIONS_KIND_DUMP:
                        visit_type_NetdevDumpOptions(m, &(*obj)->dump, "data", &err);
                        break;
                    case NET_CLIENT_OPTIONS_KIND_BRIDGE:
                        visit_type_NetdevBridgeOptions(m, &(*obj)->bridge, "data", &err);
                        break;
                    case NET_CLIENT_OPTIONS_KIND_HUBPORT:
                        visit_type_NetdevHubPortOptions(m, &(*obj)->hubport, "data", &err);
                        break;
                    case NET_CLIENT_OPTIONS_KIND_NETMAP:
                        visit_type_NetdevNetmapOptions(m, &(*obj)->netmap, "data", &err);
                        break;
                    default:
                        abort();
                    }
                }
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetClientOptionsList(Visitor *m, NetClientOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NetClientOptionsList *native_i = (NetClientOptionsList *)i;
                visit_type_NetClientOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_NetLegacy_fields(Visitor *m, NetLegacy ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_vlan : NULL, "vlan", &err);
    if (obj && (*obj)->has_vlan) {
        visit_type_int32(m, obj ? &(*obj)->vlan : NULL, "vlan", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_id : NULL, "id", &err);
    if (obj && (*obj)->has_id) {
        visit_type_str(m, obj ? &(*obj)->id : NULL, "id", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_name : NULL, "name", &err);
    if (obj && (*obj)->has_name) {
        visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);
    }
    visit_end_optional(m, &err);
    visit_type_NetClientOptions(m, obj ? &(*obj)->opts : NULL, "opts", &err);

    error_propagate(errp, err);
}

void visit_type_NetLegacy(Visitor *m, NetLegacy ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "NetLegacy", name, sizeof(NetLegacy), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_NetLegacy_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetLegacyList(Visitor *m, NetLegacyList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NetLegacyList *native_i = (NetLegacyList *)i;
                visit_type_NetLegacy(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_Netdev_fields(Visitor *m, Netdev ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->id : NULL, "id", &err);
    visit_type_NetClientOptions(m, obj ? &(*obj)->opts : NULL, "opts", &err);

    error_propagate(errp, err);
}

void visit_type_Netdev(Visitor *m, Netdev ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "Netdev", name, sizeof(Netdev), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_Netdev_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_NetdevList(Visitor *m, NetdevList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                NetdevList *native_i = (NetdevList *)i;
                visit_type_Netdev(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_InetSocketAddress_fields(Visitor *m, InetSocketAddress ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->host : NULL, "host", &err);
    visit_type_str(m, obj ? &(*obj)->port : NULL, "port", &err);
    visit_start_optional(m, obj ? &(*obj)->has_to : NULL, "to", &err);
    if (obj && (*obj)->has_to) {
        visit_type_uint16(m, obj ? &(*obj)->to : NULL, "to", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_ipv4 : NULL, "ipv4", &err);
    if (obj && (*obj)->has_ipv4) {
        visit_type_bool(m, obj ? &(*obj)->ipv4 : NULL, "ipv4", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_ipv6 : NULL, "ipv6", &err);
    if (obj && (*obj)->has_ipv6) {
        visit_type_bool(m, obj ? &(*obj)->ipv6 : NULL, "ipv6", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_InetSocketAddress(Visitor *m, InetSocketAddress ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "InetSocketAddress", name, sizeof(InetSocketAddress), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_InetSocketAddress_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_InetSocketAddressList(Visitor *m, InetSocketAddressList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                InetSocketAddressList *native_i = (InetSocketAddressList *)i;
                visit_type_InetSocketAddress(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_UnixSocketAddress_fields(Visitor *m, UnixSocketAddress ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->path : NULL, "path", &err);

    error_propagate(errp, err);
}

void visit_type_UnixSocketAddress(Visitor *m, UnixSocketAddress ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "UnixSocketAddress", name, sizeof(UnixSocketAddress), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_UnixSocketAddress_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_UnixSocketAddressList(Visitor *m, UnixSocketAddressList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                UnixSocketAddressList *native_i = (UnixSocketAddressList *)i;
                visit_type_UnixSocketAddress(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_SocketAddressKind(Visitor *m, SocketAddressKind * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, SocketAddressKind_lookup, "SocketAddressKind", name, errp);
}

void visit_type_SocketAddress(Visitor *m, SocketAddress ** obj, const char *name, Error **errp)
{
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_struct(m, (void **)obj, "SocketAddress", name, sizeof(SocketAddress), &err);
        if (!err) {
            if (obj && *obj) {
                visit_type_SocketAddressKind(m, &(*obj)->kind, "type", &err);
                if (!err) {
                    switch ((*obj)->kind) {
                    case SOCKET_ADDRESS_KIND_INET:
                        visit_type_InetSocketAddress(m, &(*obj)->inet, "data", &err);
                        break;
                    case SOCKET_ADDRESS_KIND_UNIX:
                        visit_type_UnixSocketAddress(m, &(*obj)->q_unix, "data", &err);
                        break;
                    case SOCKET_ADDRESS_KIND_FD:
                        visit_type_String(m, &(*obj)->fd, "data", &err);
                        break;
                    default:
                        abort();
                    }
                }
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_SocketAddressList(Visitor *m, SocketAddressList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                SocketAddressList *native_i = (SocketAddressList *)i;
                visit_type_SocketAddress(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_MachineInfo_fields(Visitor *m, MachineInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);
    visit_start_optional(m, obj ? &(*obj)->has_alias : NULL, "alias", &err);
    if (obj && (*obj)->has_alias) {
        visit_type_str(m, obj ? &(*obj)->alias : NULL, "alias", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_is_default : NULL, "is-default", &err);
    if (obj && (*obj)->has_is_default) {
        visit_type_bool(m, obj ? &(*obj)->is_default : NULL, "is-default", &err);
    }
    visit_end_optional(m, &err);
    visit_type_int(m, obj ? &(*obj)->cpu_max : NULL, "cpu-max", &err);

    error_propagate(errp, err);
}

void visit_type_MachineInfo(Visitor *m, MachineInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "MachineInfo", name, sizeof(MachineInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_MachineInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_MachineInfoList(Visitor *m, MachineInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                MachineInfoList *native_i = (MachineInfoList *)i;
                visit_type_MachineInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_CpuDefinitionInfo_fields(Visitor *m, CpuDefinitionInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);

    error_propagate(errp, err);
}

void visit_type_CpuDefinitionInfo(Visitor *m, CpuDefinitionInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "CpuDefinitionInfo", name, sizeof(CpuDefinitionInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_CpuDefinitionInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_CpuDefinitionInfoList(Visitor *m, CpuDefinitionInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                CpuDefinitionInfoList *native_i = (CpuDefinitionInfoList *)i;
                visit_type_CpuDefinitionInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_AddfdInfo_fields(Visitor *m, AddfdInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->fdset_id : NULL, "fdset-id", &err);
    visit_type_int(m, obj ? &(*obj)->fd : NULL, "fd", &err);

    error_propagate(errp, err);
}

void visit_type_AddfdInfo(Visitor *m, AddfdInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "AddfdInfo", name, sizeof(AddfdInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_AddfdInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_AddfdInfoList(Visitor *m, AddfdInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                AddfdInfoList *native_i = (AddfdInfoList *)i;
                visit_type_AddfdInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_FdsetFdInfo_fields(Visitor *m, FdsetFdInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->fd : NULL, "fd", &err);
    visit_start_optional(m, obj ? &(*obj)->has_opaque : NULL, "opaque", &err);
    if (obj && (*obj)->has_opaque) {
        visit_type_str(m, obj ? &(*obj)->opaque : NULL, "opaque", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_FdsetFdInfo(Visitor *m, FdsetFdInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "FdsetFdInfo", name, sizeof(FdsetFdInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_FdsetFdInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_FdsetFdInfoList(Visitor *m, FdsetFdInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                FdsetFdInfoList *native_i = (FdsetFdInfoList *)i;
                visit_type_FdsetFdInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_FdsetInfo_fields(Visitor *m, FdsetInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->fdset_id : NULL, "fdset-id", &err);
    visit_type_FdsetFdInfoList(m, obj ? &(*obj)->fds : NULL, "fds", &err);

    error_propagate(errp, err);
}

void visit_type_FdsetInfo(Visitor *m, FdsetInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "FdsetInfo", name, sizeof(FdsetInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_FdsetInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_FdsetInfoList(Visitor *m, FdsetInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                FdsetInfoList *native_i = (FdsetInfoList *)i;
                visit_type_FdsetInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_TargetInfo_fields(Visitor *m, TargetInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->arch : NULL, "arch", &err);

    error_propagate(errp, err);
}

void visit_type_TargetInfo(Visitor *m, TargetInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "TargetInfo", name, sizeof(TargetInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_TargetInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_TargetInfoList(Visitor *m, TargetInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                TargetInfoList *native_i = (TargetInfoList *)i;
                visit_type_TargetInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_QKeyCodeList(Visitor *m, QKeyCodeList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                QKeyCodeList *native_i = (QKeyCodeList *)i;
                visit_type_QKeyCode(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_QKeyCode(Visitor *m, QKeyCode * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, QKeyCode_lookup, "QKeyCode", name, errp);
}

void visit_type_KeyValueKind(Visitor *m, KeyValueKind * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, KeyValueKind_lookup, "KeyValueKind", name, errp);
}

void visit_type_KeyValue(Visitor *m, KeyValue ** obj, const char *name, Error **errp)
{
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_struct(m, (void **)obj, "KeyValue", name, sizeof(KeyValue), &err);
        if (!err) {
            if (obj && *obj) {
                visit_type_KeyValueKind(m, &(*obj)->kind, "type", &err);
                if (!err) {
                    switch ((*obj)->kind) {
                    case KEY_VALUE_KIND_NUMBER:
                        visit_type_int(m, &(*obj)->number, "data", &err);
                        break;
                    case KEY_VALUE_KIND_QCODE:
                        visit_type_QKeyCode(m, &(*obj)->qcode, "data", &err);
                        break;
                    default:
                        abort();
                    }
                }
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_KeyValueList(Visitor *m, KeyValueList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                KeyValueList *native_i = (KeyValueList *)i;
                visit_type_KeyValue(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ChardevFile_fields(Visitor *m, ChardevFile ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_in : NULL, "in", &err);
    if (obj && (*obj)->has_in) {
        visit_type_str(m, obj ? &(*obj)->in : NULL, "in", &err);
    }
    visit_end_optional(m, &err);
    visit_type_str(m, obj ? &(*obj)->out : NULL, "out", &err);

    error_propagate(errp, err);
}

void visit_type_ChardevFile(Visitor *m, ChardevFile ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevFile", name, sizeof(ChardevFile), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevFile_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevFileList(Visitor *m, ChardevFileList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevFileList *native_i = (ChardevFileList *)i;
                visit_type_ChardevFile(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ChardevHostdev_fields(Visitor *m, ChardevHostdev ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->device : NULL, "device", &err);

    error_propagate(errp, err);
}

void visit_type_ChardevHostdev(Visitor *m, ChardevHostdev ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevHostdev", name, sizeof(ChardevHostdev), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevHostdev_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevHostdevList(Visitor *m, ChardevHostdevList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevHostdevList *native_i = (ChardevHostdevList *)i;
                visit_type_ChardevHostdev(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ChardevSocket_fields(Visitor *m, ChardevSocket ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_SocketAddress(m, obj ? &(*obj)->addr : NULL, "addr", &err);
    visit_start_optional(m, obj ? &(*obj)->has_server : NULL, "server", &err);
    if (obj && (*obj)->has_server) {
        visit_type_bool(m, obj ? &(*obj)->server : NULL, "server", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_wait : NULL, "wait", &err);
    if (obj && (*obj)->has_wait) {
        visit_type_bool(m, obj ? &(*obj)->wait : NULL, "wait", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_nodelay : NULL, "nodelay", &err);
    if (obj && (*obj)->has_nodelay) {
        visit_type_bool(m, obj ? &(*obj)->nodelay : NULL, "nodelay", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_telnet : NULL, "telnet", &err);
    if (obj && (*obj)->has_telnet) {
        visit_type_bool(m, obj ? &(*obj)->telnet : NULL, "telnet", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_ChardevSocket(Visitor *m, ChardevSocket ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevSocket", name, sizeof(ChardevSocket), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevSocket_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevSocketList(Visitor *m, ChardevSocketList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevSocketList *native_i = (ChardevSocketList *)i;
                visit_type_ChardevSocket(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ChardevUdp_fields(Visitor *m, ChardevUdp ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_SocketAddress(m, obj ? &(*obj)->remote : NULL, "remote", &err);
    visit_start_optional(m, obj ? &(*obj)->has_local : NULL, "local", &err);
    if (obj && (*obj)->has_local) {
        visit_type_SocketAddress(m, obj ? &(*obj)->local : NULL, "local", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_ChardevUdp(Visitor *m, ChardevUdp ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevUdp", name, sizeof(ChardevUdp), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevUdp_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevUdpList(Visitor *m, ChardevUdpList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevUdpList *native_i = (ChardevUdpList *)i;
                visit_type_ChardevUdp(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ChardevMux_fields(Visitor *m, ChardevMux ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->chardev : NULL, "chardev", &err);

    error_propagate(errp, err);
}

void visit_type_ChardevMux(Visitor *m, ChardevMux ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevMux", name, sizeof(ChardevMux), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevMux_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevMuxList(Visitor *m, ChardevMuxList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevMuxList *native_i = (ChardevMuxList *)i;
                visit_type_ChardevMux(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ChardevStdio_fields(Visitor *m, ChardevStdio ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_signal : NULL, "signal", &err);
    if (obj && (*obj)->has_signal) {
        visit_type_bool(m, obj ? &(*obj)->signal : NULL, "signal", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_ChardevStdio(Visitor *m, ChardevStdio ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevStdio", name, sizeof(ChardevStdio), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevStdio_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevStdioList(Visitor *m, ChardevStdioList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevStdioList *native_i = (ChardevStdioList *)i;
                visit_type_ChardevStdio(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ChardevSpiceChannel_fields(Visitor *m, ChardevSpiceChannel ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->type : NULL, "type", &err);

    error_propagate(errp, err);
}

void visit_type_ChardevSpiceChannel(Visitor *m, ChardevSpiceChannel ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevSpiceChannel", name, sizeof(ChardevSpiceChannel), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevSpiceChannel_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevSpiceChannelList(Visitor *m, ChardevSpiceChannelList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevSpiceChannelList *native_i = (ChardevSpiceChannelList *)i;
                visit_type_ChardevSpiceChannel(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ChardevSpicePort_fields(Visitor *m, ChardevSpicePort ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->fqdn : NULL, "fqdn", &err);

    error_propagate(errp, err);
}

void visit_type_ChardevSpicePort(Visitor *m, ChardevSpicePort ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevSpicePort", name, sizeof(ChardevSpicePort), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevSpicePort_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevSpicePortList(Visitor *m, ChardevSpicePortList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevSpicePortList *native_i = (ChardevSpicePortList *)i;
                visit_type_ChardevSpicePort(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ChardevVC_fields(Visitor *m, ChardevVC ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_width : NULL, "width", &err);
    if (obj && (*obj)->has_width) {
        visit_type_int(m, obj ? &(*obj)->width : NULL, "width", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_height : NULL, "height", &err);
    if (obj && (*obj)->has_height) {
        visit_type_int(m, obj ? &(*obj)->height : NULL, "height", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_cols : NULL, "cols", &err);
    if (obj && (*obj)->has_cols) {
        visit_type_int(m, obj ? &(*obj)->cols : NULL, "cols", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_rows : NULL, "rows", &err);
    if (obj && (*obj)->has_rows) {
        visit_type_int(m, obj ? &(*obj)->rows : NULL, "rows", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_ChardevVC(Visitor *m, ChardevVC ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevVC", name, sizeof(ChardevVC), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevVC_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevVCList(Visitor *m, ChardevVCList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevVCList *native_i = (ChardevVCList *)i;
                visit_type_ChardevVC(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ChardevRingbuf_fields(Visitor *m, ChardevRingbuf ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_size : NULL, "size", &err);
    if (obj && (*obj)->has_size) {
        visit_type_int(m, obj ? &(*obj)->size : NULL, "size", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_ChardevRingbuf(Visitor *m, ChardevRingbuf ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevRingbuf", name, sizeof(ChardevRingbuf), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevRingbuf_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevRingbufList(Visitor *m, ChardevRingbufList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevRingbufList *native_i = (ChardevRingbufList *)i;
                visit_type_ChardevRingbuf(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ChardevDummy_fields(Visitor *m, ChardevDummy ** obj, Error **errp)
{
    Error *err = NULL;

    error_propagate(errp, err);
}

void visit_type_ChardevDummy(Visitor *m, ChardevDummy ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevDummy", name, sizeof(ChardevDummy), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevDummy_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevDummyList(Visitor *m, ChardevDummyList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevDummyList *native_i = (ChardevDummyList *)i;
                visit_type_ChardevDummy(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevBackendKind(Visitor *m, ChardevBackendKind * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, ChardevBackendKind_lookup, "ChardevBackendKind", name, errp);
}

void visit_type_ChardevBackend(Visitor *m, ChardevBackend ** obj, const char *name, Error **errp)
{
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_struct(m, (void **)obj, "ChardevBackend", name, sizeof(ChardevBackend), &err);
        if (!err) {
            if (obj && *obj) {
                visit_type_ChardevBackendKind(m, &(*obj)->kind, "type", &err);
                if (!err) {
                    switch ((*obj)->kind) {
                    case CHARDEV_BACKEND_KIND_FILE:
                        visit_type_ChardevFile(m, &(*obj)->file, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_SERIAL:
                        visit_type_ChardevHostdev(m, &(*obj)->serial, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_PARALLEL:
                        visit_type_ChardevHostdev(m, &(*obj)->parallel, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_PIPE:
                        visit_type_ChardevHostdev(m, &(*obj)->pipe, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_SOCKET:
                        visit_type_ChardevSocket(m, &(*obj)->socket, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_UDP:
                        visit_type_ChardevUdp(m, &(*obj)->udp, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_PTY:
                        visit_type_ChardevDummy(m, &(*obj)->pty, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_NULL:
                        visit_type_ChardevDummy(m, &(*obj)->null, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_MUX:
                        visit_type_ChardevMux(m, &(*obj)->mux, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_MSMOUSE:
                        visit_type_ChardevDummy(m, &(*obj)->msmouse, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_BRAILLE:
                        visit_type_ChardevDummy(m, &(*obj)->braille, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_STDIO:
                        visit_type_ChardevStdio(m, &(*obj)->stdio, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_CONSOLE:
                        visit_type_ChardevDummy(m, &(*obj)->console, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_SPICEVMC:
                        visit_type_ChardevSpiceChannel(m, &(*obj)->spicevmc, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_SPICEPORT:
                        visit_type_ChardevSpicePort(m, &(*obj)->spiceport, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_VC:
                        visit_type_ChardevVC(m, &(*obj)->vc, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_RINGBUF:
                        visit_type_ChardevRingbuf(m, &(*obj)->ringbuf, "data", &err);
                        break;
                    case CHARDEV_BACKEND_KIND_MEMORY:
                        visit_type_ChardevRingbuf(m, &(*obj)->memory, "data", &err);
                        break;
                    default:
                        abort();
                    }
                }
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevBackendList(Visitor *m, ChardevBackendList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevBackendList *native_i = (ChardevBackendList *)i;
                visit_type_ChardevBackend(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_ChardevReturn_fields(Visitor *m, ChardevReturn ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_pty : NULL, "pty", &err);
    if (obj && (*obj)->has_pty) {
        visit_type_str(m, obj ? &(*obj)->pty : NULL, "pty", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_ChardevReturn(Visitor *m, ChardevReturn ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "ChardevReturn", name, sizeof(ChardevReturn), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_ChardevReturn_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_ChardevReturnList(Visitor *m, ChardevReturnList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                ChardevReturnList *native_i = (ChardevReturnList *)i;
                visit_type_ChardevReturn(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_TpmModelList(Visitor *m, TpmModelList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                TpmModelList *native_i = (TpmModelList *)i;
                visit_type_TpmModel(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_TpmModel(Visitor *m, TpmModel * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, TpmModel_lookup, "TpmModel", name, errp);
}

void visit_type_TpmTypeList(Visitor *m, TpmTypeList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                TpmTypeList *native_i = (TpmTypeList *)i;
                visit_type_TpmType(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_TpmType(Visitor *m, TpmType * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, TpmType_lookup, "TpmType", name, errp);
}

static void visit_type_TPMPassthroughOptions_fields(Visitor *m, TPMPassthroughOptions ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_path : NULL, "path", &err);
    if (obj && (*obj)->has_path) {
        visit_type_str(m, obj ? &(*obj)->path : NULL, "path", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_cancel_path : NULL, "cancel-path", &err);
    if (obj && (*obj)->has_cancel_path) {
        visit_type_str(m, obj ? &(*obj)->cancel_path : NULL, "cancel-path", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_TPMPassthroughOptions(Visitor *m, TPMPassthroughOptions ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "TPMPassthroughOptions", name, sizeof(TPMPassthroughOptions), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_TPMPassthroughOptions_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_TPMPassthroughOptionsList(Visitor *m, TPMPassthroughOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                TPMPassthroughOptionsList *native_i = (TPMPassthroughOptionsList *)i;
                visit_type_TPMPassthroughOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_TpmTypeOptionsKind(Visitor *m, TpmTypeOptionsKind * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, TpmTypeOptionsKind_lookup, "TpmTypeOptionsKind", name, errp);
}

void visit_type_TpmTypeOptions(Visitor *m, TpmTypeOptions ** obj, const char *name, Error **errp)
{
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_struct(m, (void **)obj, "TpmTypeOptions", name, sizeof(TpmTypeOptions), &err);
        if (!err) {
            if (obj && *obj) {
                visit_type_TpmTypeOptionsKind(m, &(*obj)->kind, "type", &err);
                if (!err) {
                    switch ((*obj)->kind) {
                    case TPM_TYPE_OPTIONS_KIND_PASSTHROUGH:
                        visit_type_TPMPassthroughOptions(m, &(*obj)->passthrough, "data", &err);
                        break;
                    default:
                        abort();
                    }
                }
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_TpmTypeOptionsList(Visitor *m, TpmTypeOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                TpmTypeOptionsList *native_i = (TpmTypeOptionsList *)i;
                visit_type_TpmTypeOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_TPMInfo_fields(Visitor *m, TPMInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->id : NULL, "id", &err);
    visit_type_TpmModel(m, obj ? &(*obj)->model : NULL, "model", &err);
    visit_type_TpmTypeOptions(m, obj ? &(*obj)->options : NULL, "options", &err);

    error_propagate(errp, err);
}

void visit_type_TPMInfo(Visitor *m, TPMInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "TPMInfo", name, sizeof(TPMInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_TPMInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_TPMInfoList(Visitor *m, TPMInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                TPMInfoList *native_i = (TPMInfoList *)i;
                visit_type_TPMInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_AcpiTableOptions_fields(Visitor *m, AcpiTableOptions ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_sig : NULL, "sig", &err);
    if (obj && (*obj)->has_sig) {
        visit_type_str(m, obj ? &(*obj)->sig : NULL, "sig", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_rev : NULL, "rev", &err);
    if (obj && (*obj)->has_rev) {
        visit_type_uint8(m, obj ? &(*obj)->rev : NULL, "rev", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_oem_id : NULL, "oem_id", &err);
    if (obj && (*obj)->has_oem_id) {
        visit_type_str(m, obj ? &(*obj)->oem_id : NULL, "oem_id", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_oem_table_id : NULL, "oem_table_id", &err);
    if (obj && (*obj)->has_oem_table_id) {
        visit_type_str(m, obj ? &(*obj)->oem_table_id : NULL, "oem_table_id", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_oem_rev : NULL, "oem_rev", &err);
    if (obj && (*obj)->has_oem_rev) {
        visit_type_uint32(m, obj ? &(*obj)->oem_rev : NULL, "oem_rev", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_asl_compiler_id : NULL, "asl_compiler_id", &err);
    if (obj && (*obj)->has_asl_compiler_id) {
        visit_type_str(m, obj ? &(*obj)->asl_compiler_id : NULL, "asl_compiler_id", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_asl_compiler_rev : NULL, "asl_compiler_rev", &err);
    if (obj && (*obj)->has_asl_compiler_rev) {
        visit_type_uint32(m, obj ? &(*obj)->asl_compiler_rev : NULL, "asl_compiler_rev", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_file : NULL, "file", &err);
    if (obj && (*obj)->has_file) {
        visit_type_str(m, obj ? &(*obj)->file : NULL, "file", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_data : NULL, "data", &err);
    if (obj && (*obj)->has_data) {
        visit_type_str(m, obj ? &(*obj)->data : NULL, "data", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_AcpiTableOptions(Visitor *m, AcpiTableOptions ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "AcpiTableOptions", name, sizeof(AcpiTableOptions), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_AcpiTableOptions_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_AcpiTableOptionsList(Visitor *m, AcpiTableOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                AcpiTableOptionsList *native_i = (AcpiTableOptionsList *)i;
                visit_type_AcpiTableOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_CommandLineParameterTypeList(Visitor *m, CommandLineParameterTypeList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                CommandLineParameterTypeList *native_i = (CommandLineParameterTypeList *)i;
                visit_type_CommandLineParameterType(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_CommandLineParameterType(Visitor *m, CommandLineParameterType * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, CommandLineParameterType_lookup, "CommandLineParameterType", name, errp);
}

static void visit_type_CommandLineParameterInfo_fields(Visitor *m, CommandLineParameterInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);
    visit_type_CommandLineParameterType(m, obj ? &(*obj)->type : NULL, "type", &err);
    visit_start_optional(m, obj ? &(*obj)->has_help : NULL, "help", &err);
    if (obj && (*obj)->has_help) {
        visit_type_str(m, obj ? &(*obj)->help : NULL, "help", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_CommandLineParameterInfo(Visitor *m, CommandLineParameterInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "CommandLineParameterInfo", name, sizeof(CommandLineParameterInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_CommandLineParameterInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_CommandLineParameterInfoList(Visitor *m, CommandLineParameterInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                CommandLineParameterInfoList *native_i = (CommandLineParameterInfoList *)i;
                visit_type_CommandLineParameterInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_CommandLineOptionInfo_fields(Visitor *m, CommandLineOptionInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->option : NULL, "option", &err);
    visit_type_CommandLineParameterInfoList(m, obj ? &(*obj)->parameters : NULL, "parameters", &err);

    error_propagate(errp, err);
}

void visit_type_CommandLineOptionInfo(Visitor *m, CommandLineOptionInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "CommandLineOptionInfo", name, sizeof(CommandLineOptionInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_CommandLineOptionInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_CommandLineOptionInfoList(Visitor *m, CommandLineOptionInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                CommandLineOptionInfoList *native_i = (CommandLineOptionInfoList *)i;
                visit_type_CommandLineOptionInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_X86CPURegister32List(Visitor *m, X86CPURegister32List ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                X86CPURegister32List *native_i = (X86CPURegister32List *)i;
                visit_type_X86CPURegister32(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_X86CPURegister32(Visitor *m, X86CPURegister32 * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, X86CPURegister32_lookup, "X86CPURegister32", name, errp);
}

static void visit_type_X86CPUFeatureWordInfo_fields(Visitor *m, X86CPUFeatureWordInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_int(m, obj ? &(*obj)->cpuid_input_eax : NULL, "cpuid-input-eax", &err);
    visit_start_optional(m, obj ? &(*obj)->has_cpuid_input_ecx : NULL, "cpuid-input-ecx", &err);
    if (obj && (*obj)->has_cpuid_input_ecx) {
        visit_type_int(m, obj ? &(*obj)->cpuid_input_ecx : NULL, "cpuid-input-ecx", &err);
    }
    visit_end_optional(m, &err);
    visit_type_X86CPURegister32(m, obj ? &(*obj)->cpuid_register : NULL, "cpuid-register", &err);
    visit_type_int(m, obj ? &(*obj)->features : NULL, "features", &err);

    error_propagate(errp, err);
}

void visit_type_X86CPUFeatureWordInfo(Visitor *m, X86CPUFeatureWordInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "X86CPUFeatureWordInfo", name, sizeof(X86CPUFeatureWordInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_X86CPUFeatureWordInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_X86CPUFeatureWordInfoList(Visitor *m, X86CPUFeatureWordInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                X86CPUFeatureWordInfoList *native_i = (X86CPUFeatureWordInfoList *)i;
                visit_type_X86CPUFeatureWordInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_RxStateList(Visitor *m, RxStateList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                RxStateList *native_i = (RxStateList *)i;
                visit_type_RxState(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_RxState(Visitor *m, RxState * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, RxState_lookup, "RxState", name, errp);
}

static void visit_type_RxFilterInfo_fields(Visitor *m, RxFilterInfo ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->name : NULL, "name", &err);
    visit_type_bool(m, obj ? &(*obj)->promiscuous : NULL, "promiscuous", &err);
    visit_type_RxState(m, obj ? &(*obj)->multicast : NULL, "multicast", &err);
    visit_type_RxState(m, obj ? &(*obj)->unicast : NULL, "unicast", &err);
    visit_type_bool(m, obj ? &(*obj)->broadcast_allowed : NULL, "broadcast-allowed", &err);
    visit_type_bool(m, obj ? &(*obj)->multicast_overflow : NULL, "multicast-overflow", &err);
    visit_type_bool(m, obj ? &(*obj)->unicast_overflow : NULL, "unicast-overflow", &err);
    visit_type_str(m, obj ? &(*obj)->main_mac : NULL, "main-mac", &err);
    visit_type_intList(m, obj ? &(*obj)->vlan_table : NULL, "vlan-table", &err);
    visit_type_strList(m, obj ? &(*obj)->unicast_table : NULL, "unicast-table", &err);
    visit_type_strList(m, obj ? &(*obj)->multicast_table : NULL, "multicast-table", &err);

    error_propagate(errp, err);
}

void visit_type_RxFilterInfo(Visitor *m, RxFilterInfo ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "RxFilterInfo", name, sizeof(RxFilterInfo), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_RxFilterInfo_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_RxFilterInfoList(Visitor *m, RxFilterInfoList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                RxFilterInfoList *native_i = (RxFilterInfoList *)i;
                visit_type_RxFilterInfo(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevDiscardOptionsList(Visitor *m, BlockdevDiscardOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevDiscardOptionsList *native_i = (BlockdevDiscardOptionsList *)i;
                visit_type_BlockdevDiscardOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevDiscardOptions(Visitor *m, BlockdevDiscardOptions * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, BlockdevDiscardOptions_lookup, "BlockdevDiscardOptions", name, errp);
}

void visit_type_BlockdevAioOptionsList(Visitor *m, BlockdevAioOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevAioOptionsList *native_i = (BlockdevAioOptionsList *)i;
                visit_type_BlockdevAioOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevAioOptions(Visitor *m, BlockdevAioOptions * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, BlockdevAioOptions_lookup, "BlockdevAioOptions", name, errp);
}

static void visit_type_BlockdevCacheOptions_fields(Visitor *m, BlockdevCacheOptions ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_writeback : NULL, "writeback", &err);
    if (obj && (*obj)->has_writeback) {
        visit_type_bool(m, obj ? &(*obj)->writeback : NULL, "writeback", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_direct : NULL, "direct", &err);
    if (obj && (*obj)->has_direct) {
        visit_type_bool(m, obj ? &(*obj)->direct : NULL, "direct", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_no_flush : NULL, "no-flush", &err);
    if (obj && (*obj)->has_no_flush) {
        visit_type_bool(m, obj ? &(*obj)->no_flush : NULL, "no-flush", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_BlockdevCacheOptions(Visitor *m, BlockdevCacheOptions ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockdevCacheOptions", name, sizeof(BlockdevCacheOptions), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockdevCacheOptions_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevCacheOptionsList(Visitor *m, BlockdevCacheOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevCacheOptionsList *native_i = (BlockdevCacheOptionsList *)i;
                visit_type_BlockdevCacheOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_BlockdevOptionsBase_fields(Visitor *m, BlockdevOptionsBase ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->driver : NULL, "driver", &err);
    visit_start_optional(m, obj ? &(*obj)->has_id : NULL, "id", &err);
    if (obj && (*obj)->has_id) {
        visit_type_str(m, obj ? &(*obj)->id : NULL, "id", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_discard : NULL, "discard", &err);
    if (obj && (*obj)->has_discard) {
        visit_type_BlockdevDiscardOptions(m, obj ? &(*obj)->discard : NULL, "discard", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_cache : NULL, "cache", &err);
    if (obj && (*obj)->has_cache) {
        visit_type_BlockdevCacheOptions(m, obj ? &(*obj)->cache : NULL, "cache", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_aio : NULL, "aio", &err);
    if (obj && (*obj)->has_aio) {
        visit_type_BlockdevAioOptions(m, obj ? &(*obj)->aio : NULL, "aio", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_rerror : NULL, "rerror", &err);
    if (obj && (*obj)->has_rerror) {
        visit_type_BlockdevOnError(m, obj ? &(*obj)->rerror : NULL, "rerror", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_werror : NULL, "werror", &err);
    if (obj && (*obj)->has_werror) {
        visit_type_BlockdevOnError(m, obj ? &(*obj)->werror : NULL, "werror", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_read_only : NULL, "read-only", &err);
    if (obj && (*obj)->has_read_only) {
        visit_type_bool(m, obj ? &(*obj)->read_only : NULL, "read-only", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_BlockdevOptionsBase(Visitor *m, BlockdevOptionsBase ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockdevOptionsBase", name, sizeof(BlockdevOptionsBase), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockdevOptionsBase_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevOptionsBaseList(Visitor *m, BlockdevOptionsBaseList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevOptionsBaseList *native_i = (BlockdevOptionsBaseList *)i;
                visit_type_BlockdevOptionsBase(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_BlockdevOptionsFile_fields(Visitor *m, BlockdevOptionsFile ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->filename : NULL, "filename", &err);

    error_propagate(errp, err);
}

void visit_type_BlockdevOptionsFile(Visitor *m, BlockdevOptionsFile ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockdevOptionsFile", name, sizeof(BlockdevOptionsFile), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockdevOptionsFile_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevOptionsFileList(Visitor *m, BlockdevOptionsFileList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevOptionsFileList *native_i = (BlockdevOptionsFileList *)i;
                visit_type_BlockdevOptionsFile(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_BlockdevOptionsVVFAT_fields(Visitor *m, BlockdevOptionsVVFAT ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_str(m, obj ? &(*obj)->dir : NULL, "dir", &err);
    visit_start_optional(m, obj ? &(*obj)->has_fat_type : NULL, "fat-type", &err);
    if (obj && (*obj)->has_fat_type) {
        visit_type_int(m, obj ? &(*obj)->fat_type : NULL, "fat-type", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_floppy : NULL, "floppy", &err);
    if (obj && (*obj)->has_floppy) {
        visit_type_bool(m, obj ? &(*obj)->floppy : NULL, "floppy", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_rw : NULL, "rw", &err);
    if (obj && (*obj)->has_rw) {
        visit_type_bool(m, obj ? &(*obj)->rw : NULL, "rw", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_BlockdevOptionsVVFAT(Visitor *m, BlockdevOptionsVVFAT ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockdevOptionsVVFAT", name, sizeof(BlockdevOptionsVVFAT), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockdevOptionsVVFAT_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevOptionsVVFATList(Visitor *m, BlockdevOptionsVVFATList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevOptionsVVFATList *native_i = (BlockdevOptionsVVFATList *)i;
                visit_type_BlockdevOptionsVVFAT(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_BlockdevOptionsGenericFormat_fields(Visitor *m, BlockdevOptionsGenericFormat ** obj, Error **errp)
{
    Error *err = NULL;
    visit_type_BlockdevRef(m, obj ? &(*obj)->file : NULL, "file", &err);

    error_propagate(errp, err);
}

void visit_type_BlockdevOptionsGenericFormat(Visitor *m, BlockdevOptionsGenericFormat ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockdevOptionsGenericFormat", name, sizeof(BlockdevOptionsGenericFormat), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockdevOptionsGenericFormat_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevOptionsGenericFormatList(Visitor *m, BlockdevOptionsGenericFormatList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevOptionsGenericFormatList *native_i = (BlockdevOptionsGenericFormatList *)i;
                visit_type_BlockdevOptionsGenericFormat(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_BlockdevOptionsGenericCOWFormat_fields(Visitor *m, BlockdevOptionsGenericCOWFormat ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_implicit_struct(m, obj ? (void**) &(*obj)->base : NULL, sizeof(BlockdevOptionsGenericFormat), &err);
    if (!err) {
        visit_type_BlockdevOptionsGenericFormat_fields(m, obj ? &(*obj)->base : NULL, &err);
        error_propagate(errp, err);
        err = NULL;
        visit_end_implicit_struct(m, &err);
    }
    visit_start_optional(m, obj ? &(*obj)->has_backing : NULL, "backing", &err);
    if (obj && (*obj)->has_backing) {
        visit_type_BlockdevRef(m, obj ? &(*obj)->backing : NULL, "backing", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_BlockdevOptionsGenericCOWFormat(Visitor *m, BlockdevOptionsGenericCOWFormat ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockdevOptionsGenericCOWFormat", name, sizeof(BlockdevOptionsGenericCOWFormat), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockdevOptionsGenericCOWFormat_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevOptionsGenericCOWFormatList(Visitor *m, BlockdevOptionsGenericCOWFormatList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevOptionsGenericCOWFormatList *native_i = (BlockdevOptionsGenericCOWFormatList *)i;
                visit_type_BlockdevOptionsGenericCOWFormat(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

static void visit_type_BlockdevOptionsQcow2_fields(Visitor *m, BlockdevOptionsQcow2 ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_implicit_struct(m, obj ? (void**) &(*obj)->base : NULL, sizeof(BlockdevOptionsGenericCOWFormat), &err);
    if (!err) {
        visit_type_BlockdevOptionsGenericCOWFormat_fields(m, obj ? &(*obj)->base : NULL, &err);
        error_propagate(errp, err);
        err = NULL;
        visit_end_implicit_struct(m, &err);
    }
    visit_start_optional(m, obj ? &(*obj)->has_lazy_refcounts : NULL, "lazy-refcounts", &err);
    if (obj && (*obj)->has_lazy_refcounts) {
        visit_type_bool(m, obj ? &(*obj)->lazy_refcounts : NULL, "lazy-refcounts", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_pass_discard_request : NULL, "pass-discard-request", &err);
    if (obj && (*obj)->has_pass_discard_request) {
        visit_type_bool(m, obj ? &(*obj)->pass_discard_request : NULL, "pass-discard-request", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_pass_discard_snapshot : NULL, "pass-discard-snapshot", &err);
    if (obj && (*obj)->has_pass_discard_snapshot) {
        visit_type_bool(m, obj ? &(*obj)->pass_discard_snapshot : NULL, "pass-discard-snapshot", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_pass_discard_other : NULL, "pass-discard-other", &err);
    if (obj && (*obj)->has_pass_discard_other) {
        visit_type_bool(m, obj ? &(*obj)->pass_discard_other : NULL, "pass-discard-other", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_BlockdevOptionsQcow2(Visitor *m, BlockdevOptionsQcow2 ** obj, const char *name, Error **errp)
{
    if (!error_is_set(errp)) {
        Error *err = NULL;
        visit_start_struct(m, (void **)obj, "BlockdevOptionsQcow2", name, sizeof(BlockdevOptionsQcow2), &err);
        if (!err) {
            if (!obj || *obj) {
                visit_type_BlockdevOptionsQcow2_fields(m, obj, &err);
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevOptionsQcow2List(Visitor *m, BlockdevOptionsQcow2List ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevOptionsQcow2List *native_i = (BlockdevOptionsQcow2List *)i;
                visit_type_BlockdevOptionsQcow2(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevOptionsKind(Visitor *m, BlockdevOptionsKind * obj, const char *name, Error **errp)
{
    visit_type_enum(m, (int *)obj, BlockdevOptionsKind_lookup, "BlockdevOptionsKind", name, errp);
}

static void visit_type_BlockdevOptions_fields(Visitor *m, BlockdevOptions ** obj, Error **errp)
{
    Error *err = NULL;
    visit_start_optional(m, obj ? &(*obj)->has_id : NULL, "id", &err);
    if (obj && (*obj)->has_id) {
        visit_type_str(m, obj ? &(*obj)->id : NULL, "id", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_discard : NULL, "discard", &err);
    if (obj && (*obj)->has_discard) {
        visit_type_BlockdevDiscardOptions(m, obj ? &(*obj)->discard : NULL, "discard", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_cache : NULL, "cache", &err);
    if (obj && (*obj)->has_cache) {
        visit_type_BlockdevCacheOptions(m, obj ? &(*obj)->cache : NULL, "cache", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_aio : NULL, "aio", &err);
    if (obj && (*obj)->has_aio) {
        visit_type_BlockdevAioOptions(m, obj ? &(*obj)->aio : NULL, "aio", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_rerror : NULL, "rerror", &err);
    if (obj && (*obj)->has_rerror) {
        visit_type_BlockdevOnError(m, obj ? &(*obj)->rerror : NULL, "rerror", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_werror : NULL, "werror", &err);
    if (obj && (*obj)->has_werror) {
        visit_type_BlockdevOnError(m, obj ? &(*obj)->werror : NULL, "werror", &err);
    }
    visit_end_optional(m, &err);
    visit_start_optional(m, obj ? &(*obj)->has_read_only : NULL, "read-only", &err);
    if (obj && (*obj)->has_read_only) {
        visit_type_bool(m, obj ? &(*obj)->read_only : NULL, "read-only", &err);
    }
    visit_end_optional(m, &err);

    error_propagate(errp, err);
}

void visit_type_BlockdevOptions(Visitor *m, BlockdevOptions ** obj, const char *name, Error **errp)
{
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_struct(m, (void **)obj, "BlockdevOptions", name, sizeof(BlockdevOptions), &err);
        if (!err) {
            if (obj && *obj) {
                visit_type_BlockdevOptions_fields(m, obj, &err);
                visit_type_BlockdevOptionsKind(m, &(*obj)->kind, "driver", &err);
                if (!err) {
                    switch ((*obj)->kind) {
                    case BLOCKDEV_OPTIONS_KIND_FILE:
                        visit_start_implicit_struct(m, (void**) &(*obj)->file, sizeof(BlockdevOptionsFile), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsFile_fields(m, &(*obj)->file, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_HTTP:
                        visit_start_implicit_struct(m, (void**) &(*obj)->http, sizeof(BlockdevOptionsFile), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsFile_fields(m, &(*obj)->http, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_HTTPS:
                        visit_start_implicit_struct(m, (void**) &(*obj)->https, sizeof(BlockdevOptionsFile), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsFile_fields(m, &(*obj)->https, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_FTP:
                        visit_start_implicit_struct(m, (void**) &(*obj)->ftp, sizeof(BlockdevOptionsFile), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsFile_fields(m, &(*obj)->ftp, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_FTPS:
                        visit_start_implicit_struct(m, (void**) &(*obj)->ftps, sizeof(BlockdevOptionsFile), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsFile_fields(m, &(*obj)->ftps, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_TFTP:
                        visit_start_implicit_struct(m, (void**) &(*obj)->tftp, sizeof(BlockdevOptionsFile), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsFile_fields(m, &(*obj)->tftp, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_VVFAT:
                        visit_start_implicit_struct(m, (void**) &(*obj)->vvfat, sizeof(BlockdevOptionsVVFAT), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsVVFAT_fields(m, &(*obj)->vvfat, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_BOCHS:
                        visit_start_implicit_struct(m, (void**) &(*obj)->bochs, sizeof(BlockdevOptionsGenericFormat), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsGenericFormat_fields(m, &(*obj)->bochs, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_CLOOP:
                        visit_start_implicit_struct(m, (void**) &(*obj)->cloop, sizeof(BlockdevOptionsGenericFormat), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsGenericFormat_fields(m, &(*obj)->cloop, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_COW:
                        visit_start_implicit_struct(m, (void**) &(*obj)->cow, sizeof(BlockdevOptionsGenericCOWFormat), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsGenericCOWFormat_fields(m, &(*obj)->cow, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_DMG:
                        visit_start_implicit_struct(m, (void**) &(*obj)->dmg, sizeof(BlockdevOptionsGenericFormat), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsGenericFormat_fields(m, &(*obj)->dmg, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_PARALLELS:
                        visit_start_implicit_struct(m, (void**) &(*obj)->parallels, sizeof(BlockdevOptionsGenericFormat), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsGenericFormat_fields(m, &(*obj)->parallels, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_QCOW:
                        visit_start_implicit_struct(m, (void**) &(*obj)->qcow, sizeof(BlockdevOptionsGenericCOWFormat), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsGenericCOWFormat_fields(m, &(*obj)->qcow, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_QCOW2:
                        visit_start_implicit_struct(m, (void**) &(*obj)->qcow2, sizeof(BlockdevOptionsQcow2), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsQcow2_fields(m, &(*obj)->qcow2, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_QED:
                        visit_start_implicit_struct(m, (void**) &(*obj)->qed, sizeof(BlockdevOptionsGenericCOWFormat), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsGenericCOWFormat_fields(m, &(*obj)->qed, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_RAW:
                        visit_start_implicit_struct(m, (void**) &(*obj)->raw, sizeof(BlockdevOptionsGenericFormat), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsGenericFormat_fields(m, &(*obj)->raw, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_VDI:
                        visit_start_implicit_struct(m, (void**) &(*obj)->vdi, sizeof(BlockdevOptionsGenericFormat), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsGenericFormat_fields(m, &(*obj)->vdi, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_VHDX:
                        visit_start_implicit_struct(m, (void**) &(*obj)->vhdx, sizeof(BlockdevOptionsGenericFormat), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsGenericFormat_fields(m, &(*obj)->vhdx, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_VMDK:
                        visit_start_implicit_struct(m, (void**) &(*obj)->vmdk, sizeof(BlockdevOptionsGenericCOWFormat), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsGenericCOWFormat_fields(m, &(*obj)->vmdk, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    case BLOCKDEV_OPTIONS_KIND_VPC:
                        visit_start_implicit_struct(m, (void**) &(*obj)->vpc, sizeof(BlockdevOptionsGenericFormat), &err);
                        if (!err) {
                            visit_type_BlockdevOptionsGenericFormat_fields(m, &(*obj)->vpc, &err);
                            error_propagate(errp, err);
                            err = NULL;
                            visit_end_implicit_struct(m, &err);
                        }
                        break;
                    default:
                        abort();
                    }
                }
                error_propagate(errp, err);
                err = NULL;
            }
            /* Always call end_struct if start_struct succeeded.  */
            visit_end_struct(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevOptionsList(Visitor *m, BlockdevOptionsList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevOptionsList *native_i = (BlockdevOptionsList *)i;
                visit_type_BlockdevOptions(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}

void visit_type_BlockdevRef(Visitor *m, BlockdevRef ** obj, const char *name, Error **errp)
{
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_implicit_struct(m, (void**) obj, sizeof(BlockdevRef), &err);
        visit_get_next_type(m, (int*) &(*obj)->kind, BlockdevRef_qtypes, name, &err);
        switch ((*obj)->kind) {
        case BLOCKDEV_REF_KIND_DEFINITION:
            visit_type_BlockdevOptions(m, &(*obj)->definition, name, &err);
            break;
        case BLOCKDEV_REF_KIND_REFERENCE:
            visit_type_str(m, &(*obj)->reference, name, &err);
            break;
        default:
            abort();
        }
        error_propagate(errp, err);
        err = NULL;
        visit_end_implicit_struct(m, &err);
    }
}

void visit_type_BlockdevRefList(Visitor *m, BlockdevRefList ** obj, const char *name, Error **errp)
{
    GenericList *i, **prev = (GenericList **)obj;
    Error *err = NULL;

    if (!error_is_set(errp)) {
        visit_start_list(m, name, &err);
        if (!err) {
            for (; (i = visit_next_list(m, prev, &err)) != NULL; prev = &i) {
                BlockdevRefList *native_i = (BlockdevRefList *)i;
                visit_type_BlockdevRef(m, &native_i->value, NULL, &err);
            }
            error_propagate(errp, err);
            err = NULL;

            /* Always call end_list if start_list succeeded.  */
            visit_end_list(m, &err);
        }
        error_propagate(errp, err);
    }
}
